/**
 * @file LCMClient.h
 * @author RBEI/ECO32 Jiji Anna Jacob
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_business_logic
 * @brief Clienthandler to LCM for WiFiState handling
 *
 * @{
 */

#ifndef _LCM_CLIENT_H
#define _LCM_CLIENT_H

#include "ILCMClient.h"
#include "ILCMProxy.h"
#include "WBLMessages.h"
#include "asf/core/Logger.h"

namespace org
{
namespace bosch
{

class LCMClient :public ILCMClient
{
public:
   LCMClient();
   virtual ~LCMClient();
   LCMClient(const LCMClient& ref);
   LCMClient& operator=(const LCMClient& ref);

   virtual void onLCMProxyAvailable() override;
   virtual void onLCMProxyUnavailable() override;

   virtual void onWifiStateError(const LCMDBusProxy& proxy, const WiFiStateError& error) override;
   virtual void onWifiStateUpdate(const LCMDBusProxy& proxy, const WiFiStateUpdate& update) override;

   virtual void notifySTASserviceAvailability(bool isAvailable) override;
   virtual void notifyAPServiceAvailability(bool isAvailable) override;

   virtual void onDeactivateResponse(const ::boost::shared_ptr < DeActivateSetupMsg >& msg) override;
   virtual void onDeactivateError(const ::boost::shared_ptr < DeActivateSetupMsg >& msg) override;

   virtual LCMWiFiState getCurrentWiFiState();
   virtual bool setTechnologyRestrictions(bool isRestrict);
   virtual void notifyActiveWiFiSetups(WifiSetUpList wifiSetups);
private:
   void onWifiDeactivateRequest(const WifiSetUpItem& setUpItem);
   void onWifiUnblockRequest(const WifiSetUpItem& setUpItem);
   bool isStateMachineBusy(WifiMode currMode);
   bool getActiveSetUps(WifiSetUpList& wifiSetups)const;
   bool setPowered(const WifiSetUpItem& setUpItem, const bool isPowered);
   void sendDeactivateRequest(const ::boost::shared_ptr < DeActivateSetupMsg >& msg);
   void handleWifiStateUpdate();
   void processWifiStateEvent();
   bool checkUnBlockCompleted(WifiSetUpList &wifiSetups);
   bool checkBlockCompleted(WifiSetUpList &wifiSetups);
   bool validateWifiBlock(const WifiSetUpItem& setUpItem);

   ILCMProxy* _poLCMProxy;
   LCMWiFiState _currState;
   LCMWiFiState _prevState;
   WBLWifiStateRequest _wblWifiState;
   bool isRestricted;


   DECLARE_CLASS_LOGGER();

};

}//namespace bosch
}//namespace org

#endif //_LCM_CLIENT_H

/** @} */
