/**
 * @file ILCMProxy.h
 * @author RBEI/ECO32 Jiji Anna Jacob
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_business_logic
 * @brief Interface to LCM Dbus Proxy for WBL
 *
 * @{
 */

#ifndef _I_LCM_PROXY_H
#define _I_LCM_PROXY_H

#include <string>
#include "ILCMProxyCallbacks.h"
#include "ProxyTypes.h"

namespace org
{
namespace bosch
{

class ILCMProxy
{
public:
   virtual ~ILCMProxy()
   {
   }
   virtual void createProxy(const std::string portName) = 0;
   virtual void destroyProxy() = 0;
   virtual void registerProperties(ILCMProxyCallbacks& callbackIf)=0;
   virtual void deregisterProperties()=0;
   virtual act_t getWiFiState(ILCMProxyCallbacks& callbackIf)=0;
};

} //namespace bosch
} //namespace org

#endif //_I_LCM_PROXY_H

/** @} */

