/**
 * @file ILCMClient.h
 * @author RBEI/ECO32 Jiji Anna Jacob
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_business_logic
 * @brief Interface to LCM Client
 *
 * @{
 */

#ifndef _I_LCM_CLIENT_H
#define _I_LCM_CLIENT_H

#include "WBLTypes.h"
#include "WBLMessages.h"
#include "WBLMessageTypes.h"
#include "ILCMProxyCallbacks.h"

namespace org
{
namespace bosch
{

class ILCMClient:public ILCMProxyCallbacks
{
public:
   virtual ~ILCMClient()
   {
   }

   virtual void onLCMProxyAvailable() override = 0;
   virtual void onLCMProxyUnavailable() override = 0;
   virtual void onWifiStateError(const LCMDBusProxy& proxy, const WiFiStateError& error) override = 0;
   virtual void onWifiStateUpdate(const LCMDBusProxy& proxy, const WiFiStateUpdate& update) override = 0;
   virtual void onDeactivateResponse(const ::boost::shared_ptr < DeActivateSetupMsg >& msg) = 0;
   virtual void onDeactivateError(const ::boost::shared_ptr < DeActivateSetupMsg >& msg) = 0;
   virtual LCMWiFiState getCurrentWiFiState()=0;
   virtual bool setTechnologyRestrictions(bool isRestrict)=0;
   virtual void notifyActiveWiFiSetups(WifiSetUpList wifiSetups)= 0;
   virtual void notifySTASserviceAvailability(bool isAvailable)= 0;
   virtual void notifyAPServiceAvailability(bool isAvailable)= 0;
};

} //namespace bosch
} //namespace org

#endif //_I_LCM_CLIENT_H

/** @} */

