/**
 * @file IDBusNotifCallbackIf.h
 * @author RBEI/ECO3 Usman Sheik
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _DBUS_NOTIF_CALLBACK_IF_H
#define _DBUS_NOTIF_CALLBACK_IF_H

#include "DBusTypes.h"

namespace org {
	namespace bosch {

class cIDBusNotifCallbackIf :
	public cNameOwnerChangedCallbackIF {
public:
	cIDBusNotifCallbackIf() {}
	virtual ~cIDBusNotifCallbackIf() {}
	virtual void onDBusServiceAvailable(const ::std::string &busName,
			const ::std::string &objPath, const ::DBusBusType busType,
			const ::asf::core::ServiceState previousState,
			const ::asf::core::ServiceState currentState) = 0;
	virtual void onDBusServiceUnavailable(const ::std::string &busName,
			const ::std::string &objPath, const ::DBusBusType busType,
			const ::asf::core::ServiceState previousState,
			const ::asf::core::ServiceState currentState) = 0;
	virtual void onNameOwnerChangedError(const ::boost::shared_ptr< cDBusProxy >& proxy,
			const ::boost::shared_ptr< cNameOwnerChangedError >& error) override = 0;
	virtual void onNameOwnerChangedSignal(const ::boost::shared_ptr< cDBusProxy >& proxy,
			const ::boost::shared_ptr< cNameOwnerChangedSignal >& signal) override = 0;
};

	}
}

#endif //_DBUS_NOTIF_CALLBACK_IF_H
/** @} */
