/**
 * @file DBusProxyManager.h
 * @author RBEI/ECO3 Usman Sheik
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _DBUS_PROXY_MANAGER_H
#define _DBUS_PROXY_MANAGER_H

#include "asf/core/Logger.h"
#include "ProxyManager.h"
#include "DBusTypes.h"
#include "ProxyCallbacksManager.h"
#include "IDBusProxyIf.h"

namespace org {
	namespace bosch {

class cDBusProxyManager :
		public ::asf::core::ServiceAvailableIF,
		public cIDBusProxyIf {

public:
	cDBusProxyManager();
	virtual ~cDBusProxyManager();
	virtual int createProxy(const ::std::string &portName, const ::std::string &busName,
			const ::std::string &objPath, const ::DBusBusType busType, const eProxyType eType) override;
	virtual int destroyProxy(const eProxyDestroy eType, const ::std::string &busName,
			const ::DBusBusType &busType, const ::std::string objPath = "") override;
	virtual int setCallbackIf(const ::std::string& busName, const ::std::string& objPath,
			const ::DBusBusType busType, cIDBusNotifCallbackIf *cb) override;
	virtual void onAvailable(const boost::shared_ptr< ::asf::core::Proxy > &proxy,
			const ::asf::core::ServiceStateChange &stateChange) override;
	virtual void onUnavailable(const boost::shared_ptr< ::asf::core::Proxy > &proxy,
			const ::asf::core::ServiceStateChange &stateChange) override;
	virtual act_t sendGetNameOwnerRequest(const ::std::string& busName,
			const ::std::string& objPath, const ::DBusBusType busType,
			cGetNameOwnerCallbackIF& cb, const ::std::string& busname) override;

private:
	ProxyManager<cDBusProxy> m_oProxyManager;
	ProxyCallbacksManager<cIDBusNotifCallbackIf>  m_pProxyCbManager;
	DECLARE_CLASS_LOGGER();
};

	}
}

#endif //_DBUS_PROXY_MANAGER_H

/** @} */
