/**
 * @file IConnmanTechnologyProxyIf.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */


#ifndef _I_CONNMAN_TECHNOLOGY_PROXY_IF_H
#define _I_CONNMAN_TECHNOLOGY_PROXY_IF_H

#include <string>

#include "ProxyTypes.h"
#include "ConnmanTechnologyTypes.h"
#include "IConnmanTechnologyNotifCallbackIf.h"

namespace org 
{
namespace bosch 
{
// forward declarations

class IConnmanTechnologyProxyIf
{
public:

   virtual ~IConnmanTechnologyProxyIf() {}

   virtual void createProxy(const ::std::string& busName,
         const ::std::string& objPath, const ::DBusBusType busType) = 0;

   virtual void destroyProxy() = 0;

   virtual bool isProxyServiceAvailable(const ::std::string& busName,
         const ::std::string& objPath, const ::DBusBusType busType) = 0;

   virtual act_t sendGetPropertiesRequest(const ::std::string& busName,
         const ::std::string& objPath, const ::DBusBusType busType,
         ConnmanGetPropertiesCbIf& callbackIf) = 0;

   /**
    * Set callback handler.
    *
    * @param[in] busName: bus name
    * @param[in] objPath: object path
    * @param[in] busType: bus type (DBUS_BUS_SYSTEM or DBUS_BUS_SESSION)
    * @param[in] user: user
    * @param[in] callbackIf: interface to receive notifications
    */
   virtual void setCallbackIf(const ::std::string& busName,
         const ::std::string& objPath, const ::DBusBusType busType,
         ProxyUser user, IConnmanTechnologyNotifCallbackIf* callbackIf) = 0;

   /**
    * Send SetProperty request
    *
    * @param[in] busName: bus name
    * @param[in] objPath: object path
    * @param[in] busType: bus type (DBUS_BUS_SYSTEM or DBUS_BUS_SESSION)
    * @param[in] callbackIf: interface to receive response
    * @param[in] name: property name
    * @param[in] value: property value
    *
    * @return = bool
    */
   virtual bool sendSetPropertyRequest(const ::std::string& busName,
         const ::std::string& objPath, const ::DBusBusType busType,
         ConnmanSetPropertyCbIf& callbackIf, const ::std::string& name,
         const ::asf::dbus::DBusVariant& value) = 0;

};

} // namespace bosch
} // namespace org

#endif //_I_CONNMAN_TECHNOLOGY_PROXY_IF_H

/** @} */
