/**
 * @file ConnmanTechnologyProxyManager.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */

#ifndef _CONNMAN_TECHNOLOGY_PROXY_MANAGER_H
#define _CONNMAN_TECHNOLOGY_PROXY_MANAGER_H

#include <string>

#include "ProxyManager.h"
#include "ProxyCallbacksManager.h"
#include "IConnmanTechnologyProxyIf.h"

namespace org 
{
namespace bosch 
{

class ConnmanTechnologyProxyManager :
   public ::asf::core::ServiceAvailableIF,
   public IConnmanTechnologyProxyIf
{
   public:

      ConnmanTechnologyProxyManager();

      virtual ~ConnmanTechnologyProxyManager();

      // IConnmanTechnologyProxyIf implementation
      virtual void createProxy(const ::std::string& busName,
            const ::std::string& objPath, const ::DBusBusType busType) override;

      virtual void destroyProxy() override;

      virtual bool isProxyServiceAvailable(const ::std::string& busName,
            const ::std::string& objPath, const ::DBusBusType busType) override;

      virtual void setCallbackIf(const ::std::string& busName,
            const ::std::string& objPath, const ::DBusBusType busType,
            ProxyUser user, IConnmanTechnologyNotifCallbackIf* callbackIf) override;

      virtual bool sendSetPropertyRequest(const ::std::string& busName,
            const ::std::string& objPath, const ::DBusBusType busType,
            ConnmanSetPropertyCbIf& callbackIf, const ::std::string& name,
            const ::asf::dbus::DBusVariant& value) override;

      // ServiceAvailableIF implementation
      virtual void onAvailable(const boost::shared_ptr< ::asf::core::Proxy >& proxy,
            const ::asf::core::ServiceStateChange& stateChange) override;

      virtual void onUnavailable(const boost::shared_ptr< ::asf::core::Proxy >& proxy,
            const ::asf::core::ServiceStateChange& stateChange) override;

      virtual act_t sendGetPropertiesRequest(const ::std::string& busName,
            const ::std::string& objPath, const ::DBusBusType busType,
            ConnmanGetPropertiesCbIf& callbackIf) override;
   protected:

   private:

      ProxyManager< ConnmanTechnologyProxy >    _proxyManager;
      ProxyCallbacksManager< IConnmanTechnologyNotifCallbackIf >  _proxyCbManager;

      DECLARE_CLASS_LOGGER();
};


} // namespace bosch
} // namespace org

#endif //_CONNMAN_TECHNOLOGY_PROXY_MANAGER_H

/** @} */
