/**
 * @file ConnmanManagerProxyManager.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */

#ifndef _CONNMAN_MANAGER_PROXY_MANAGER_H
#define _CONNMAN_MANAGER_PROXY_MANAGER_H

#include "ProxyManager.h"
#include "ProxyCallbacksManager.h"
#include "IConnmanManagerProxyIf.h"

namespace org 
{
namespace bosch 
{


//forward declarations


class ConnmanManagerProxyManager :
   public ::asf::core::ServiceAvailableIF,
   public IConnmanManagerProxyIf
{
   public:

      ConnmanManagerProxyManager();

      virtual ~ConnmanManagerProxyManager();

      // IConnmanManagerProxyIf implementation
      virtual void createProxy() override;

      virtual void destroyProxy() override;

      virtual bool isProxyServiceAvailable() override;

      virtual void setCallbackIf(ProxyUser user, IConnmanManagerNotifCallbackIf* callbackIf) override;

      virtual act_t sendGetTechnologiesRequest(ConnmanGetTechnologiesCbIf& callbackIf) override;

      // ServiceAvailableIF implementation
      virtual void onAvailable(const boost::shared_ptr< ::asf::core::Proxy >& proxy,
            const ::asf::core::ServiceStateChange& stateChange) override;

      virtual void onUnavailable(const boost::shared_ptr< ::asf::core::Proxy >& proxy,
            const ::asf::core::ServiceStateChange& stateChange) override;

   protected:

   private:

      ProxyManager< ConnmanManagerProxy >    _proxyManager;
      ProxyCallbacksManager< IConnmanManagerNotifCallbackIf >  _proxyCbManager;

      DECLARE_CLASS_LOGGER();

};


} // namespace bosch
} // namespace org

#endif //_CONNMAN_MANAGER_PROXY_MANAGER_H

/** @} */
