/**
 * @file ConnmanDbusTechnologyProperties.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */

#ifndef _CONNMAN_DBUS_TECHNOLOGY_PROPERTIES_H
#define _CONNMAN_DBUS_TECHNOLOGY_PROPERTIES_H

#include <string>

#include "DbusProperties.h"
#include "ConnmanDbusTypes.h"

namespace org 
{
namespace bosch 
{


/**
 * Service properties class for Connman interface.
 */
class ConnmanDbusTechnologyProperties : public DbusProperties
{
public:
   ConnmanDbusTechnologyProperties();

   virtual ~ConnmanDbusTechnologyProperties();

   TechnologyPropertyName getProperty2Enum(const ::std::string& value) const;

   const ::std::string& getProperty2String(const TechnologyPropertyName value) const;

   const ::std::string& getProperty2StringTrace(const TechnologyPropertyName value) const;

private:
   const ::std::string _propertyPowered;
   const ::std::string _propertyConnected;
   const ::std::string _propertyName;
   const ::std::string _propertyType;

};

static ConnmanDbusTechnologyProperties sConnmanDbusTechProperties;

} //bosch
} //org

#endif //_CONNMAN_DBUS_TECHNOLOGY_PROPERTIES_H

/** @} */
