/**
 * @file ConnmanDbusInterfaces.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */

#ifndef _CONNMAN_DBUS_INTERFACES_H
#define _CONNMAN_DBUS_INTERFACES_H

#include <string>

#include "IDbusProperty2EnumMapping.h"
#include "ConnmanDbusTypes.h"
#include "ConnmanDbusTechnologyProperties.h"

namespace org 
{
namespace bosch 
{


/**
 * Class for Connman DBUS interfaces.
 */
class ConnmanDbusInterfaces : public IDbusProperty2EnumMapping
{
public:
   ConnmanDbusInterfaces();
   virtual ~ConnmanDbusInterfaces();

   virtual void getInterfaces(
         ::std::vector< const ::std::map< ::std::string, int >* >& interfaceList,
         const ::std::vector< int >& matchingInterfaces) const override;

   const ::std::string& getInterfaceName(const ConnmanInterface interface) const;

   inline TechnologyPropertyName getTechnologyProperty2Enum(const ::std::string& value) const
   {
      return (TechnologyPropertyName) (_technologyProperties.convertString2Enum(value));
   }

   inline const ::std::string& getTechnologyProperty2String(const TechnologyPropertyName value) const
   {
      return _technologyProperties.convertEnum2String((int)value);
   }

private:
   const ::std::string _dummy;

   const ::std::string _interfaceTechnology;

   ConnmanDbusTechnologyProperties _technologyProperties;
};


} //bosch
} //org

#endif //_CONNMAN_DBUS_INTERFACES_H

/** @} */
