/**
 * @file ProxyMetadata.cpp
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */


#include "ProxyMetadata.h"
//#nclude "asf/core/Types.h"

namespace org
{
 namespace bosch 
{

ProxyMetadata::ProxyMetadata():
      busType(DBUS_BUS_SYSTEM),
      user(e8PROXY_USER_UNKNOWN)
{
}

ProxyMetadata::ProxyMetadata(const ProxyMetadata& ref):
      busName(ref.busName),
      objPath(ref.objPath),
      busType(ref.busType),
      user(ref.user)
{
}

ProxyMetadata& ProxyMetadata::operator=(const ProxyMetadata& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   busName = ref.busName;
   objPath = ref.objPath;
   busType = ref.busType;
   user = ref.user;

   return *this;
}

bool ProxyMetadata::operator==(const ProxyMetadata& ref) const
{
   return (0 == compare(ref));
}

bool ProxyMetadata::operator!=(const ProxyMetadata& ref) const
{
   return (0 != compare(ref));
}

bool ProxyMetadata::operator<(const ProxyMetadata& ref) const
{
   return (0 > compare(ref));
}

bool ProxyMetadata::operator>(const ProxyMetadata& ref) const
{
   return (0 < compare(ref));
}

ProxyMetadata::~ProxyMetadata()
{
   user = e8PROXY_USER_UNKNOWN;
}

int ProxyMetadata::compare(const ProxyMetadata& ref) const
{
   int result;

   result = busName.compare(ref.busName);
   if(result < 0)
   {
      return -1;
   }
   else if(result > 0)
   {
      return 1;
   }

   // bus name is equal

   result = objPath.compare(ref.objPath);
   if(result < 0)
   {
      return -1;
   }
   else if(result > 0)
   {
      return 1;
   }

   // object path is equal

   if(busType < ref.busType)
   {
      return -1;
   }
   else if(busType > ref.busType)
   {
      return 1;
   }

   // bus type is equal

   //Lint Prio 2 Warning 529: Symbol not subsequently referenced
   //uintptr_t left = (uintptr_t)user;
   //uintptr_t right = (uintptr_t)ref.user;

   if(user < ref.user)
   {
      return -1;
   }
   else if(user > ref.user)
   {
      return 1;
   }

   // user is equal

   return 0;
}

} // namespace bosch
} // namespace org
