/**
 * @file DBusProxyFactory.cpp
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief Factory class for WBL's Dbus Proxies
 *
 * @{
 */


#include "DBusProxyFactory.h"
#include "WBLTypes.h"
#include "WBLDefines.h"
#include "IWpaSupplicantIfaceProxyIf.h"
#include "IWpaSupplicantProxyIf.h"
#include "WpaSupplicantIfaceProxyManager.h"
#include "WpaSupplicantProxyManager.h"
#include "WpaSupplicantBssProxyManager.h"
#include "OrgFreedesktopDBusPropertiesProxyManager.h"
#include "LoopbackProxyManager.h"
#include "DBusProxyManager.h"
#include "ConnmanServiceProxyManager.h"

namespace org 
{
namespace bosch 
{

DEFINE_CLASS_LOGGER_AND_LEVEL ("wifi_business_logic/WBLClients", DBusProxyFactory, Info);

DBusProxyFactory::DBusProxyFactory():
      _connmanManagerProxyIf(nullptr),
      _connmanTechnologyProxyIf(nullptr),
      _wapdmgrManagerProxyIf(nullptr),
      _wapdmgrAccessPointProxyIf(nullptr),
      _wapdmgrAssociatedStnProxyIf(nullptr),
      _bluezAdapterProxyIf(nullptr),
      _lcmProxyIf(nullptr)
{
   _connmanManagerProxyIf = new ConnmanManagerProxyManager;
#ifndef WBL_INCLUDE_ONLY_REGULATORY_CHANGES
   WBL_ASSERT(nullptr == _connmanManagerProxyIf);
   _connmanTechnologyProxyIf = new ConnmanTechnologyProxyManager;
   WBL_ASSERT(nullptr == _connmanTechnologyProxyIf);
   _wapdmgrManagerProxyIf = new WapdmgrManagerProxyManager;
   WBL_ASSERT(nullptr == _wapdmgrManagerProxyIf);
   _wapdmgrAccessPointProxyIf = new WapdmgrAccessPointProxyManager;
   WBL_ASSERT(nullptr == _wapdmgrAccessPointProxyIf);
   _wapdmgrAssociatedStnProxyIf = new WapdmgrAssociatedStationProxyManager;
   WBL_ASSERT(nullptr == _wapdmgrAssociatedStnProxyIf);
   _bluezAdapterProxyIf = new BluezAdapterProxyManager;
   WBL_ASSERT(nullptr == _bluezAdapterProxyIf);
#endif
   _wpaSupplicantProxyIf = new cWpaSupplicantProxyManager();
   _wpaSupplicantIfaceProxyIf = new cWpaSupplicantIfaceProxyManager();
   _orgFreedesktopDBusPropertiesProxyIf = new cOrgFreedesktopDBusPropertiesProxyManager();
   _wpaSupplicantBssProxyIf = new cWpaSupplicantBssProxyManager();
   _loopbackProxyIf = new cLoopbackProxyManager();
   _dbusProxyIf = new cDBusProxyManager();
   _connmanServiceProxyIf = new cConnManServiceProxyManager();
   _lcmProxyIf = new LCMProxy();
   WBL_ASSERT(nullptr == _lcmProxyIf);
}

DBusProxyFactory::~DBusProxyFactory()
{
   RELEASE_MEM(_connmanManagerProxyIf);
   RELEASE_MEM(_connmanTechnologyProxyIf);
   RELEASE_MEM(_wapdmgrManagerProxyIf);
   RELEASE_MEM(_wapdmgrAccessPointProxyIf);
   RELEASE_MEM(_wapdmgrAssociatedStnProxyIf);
   RELEASE_MEM(_bluezAdapterProxyIf);
   RELEASE_MEM(_wpaSupplicantProxyIf);
   RELEASE_MEM(_wpaSupplicantIfaceProxyIf);
   RELEASE_MEM(_orgFreedesktopDBusPropertiesProxyIf);
   RELEASE_MEM(_wpaSupplicantBssProxyIf);
   RELEASE_MEM(_loopbackProxyIf);
   RELEASE_MEM(_dbusProxyIf);
   RELEASE_MEM(_connmanServiceProxyIf);
   RELEASE_MEM(_lcmProxyIf);
}

IConnmanManagerProxyIf* DBusProxyFactory::getConnmanManagerProxyIf()
{
   return _connmanManagerProxyIf;
}

IConnmanTechnologyProxyIf* DBusProxyFactory::getConnmanTechnologyProxyIf()
{
   return _connmanTechnologyProxyIf;
}

IWapdmgrManagerProxyIf* DBusProxyFactory::getWapdmgrManagerProxyIf()
{
   return _wapdmgrManagerProxyIf;
}

IWapdmgrAccessPointProxyIf* DBusProxyFactory::getWapdmgrAccessPointProxyIf()
{
   return _wapdmgrAccessPointProxyIf;
}

IWapdmgrAssociatedStationProxyIf* DBusProxyFactory::getWapdmgrAssociatedStationProxyIf()
{
   return _wapdmgrAssociatedStnProxyIf;
}

IBluezAdapterProxyIf* DBusProxyFactory::getBluezAdapterProxyIf()
{
   return _bluezAdapterProxyIf;
}

cIWpaSupplicantProxyIf *DBusProxyFactory::getWpaSupplicantProxyIf()
{
	return _wpaSupplicantProxyIf;
}

cIWpaSupplicantIfaceProxyIf *DBusProxyFactory::getWpaSupplicantIfaceProxyIf()
{
	return _wpaSupplicantIfaceProxyIf;
}

cIOrgFreedesktopDBusPropertiesProxyIf *DBusProxyFactory::getOrgFreedesktopDBusPropProxyIf()
{
	return _orgFreedesktopDBusPropertiesProxyIf;
}

cIWpaSupplicantBssProxyIf *DBusProxyFactory::getWpaSupplicantBssProxyIf()	
{
	return _wpaSupplicantBssProxyIf;
}

cILoopbackProxyIf *DBusProxyFactory::getLoopbackProxyIf()
{
	return _loopbackProxyIf;
}

cIDBusProxyIf *DBusProxyFactory::getDBusProxyIf()
{
	return _dbusProxyIf;
}

cIConnManServiceProxyIf *DBusProxyFactory::getConnManServiceIf()
{
	return _connmanServiceProxyIf;
}

ILCMProxy *DBusProxyFactory::getLCMProxyIf()
{
   return _lcmProxyIf;
}



} // namespace bosch
} // namespace org

/** @} */
