/**
 * @file ProxyMetadata.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 *
 * @brief 
 *
 * @{
 */
 
#ifndef _PROXY_METADATA_H
#define _PROXY_METADATA_H

#include <string>
#include <dbus/dbus.h>

#include "ProxyTypes.h"

namespace org 
{
namespace bosch
{


/**
 * Type definition for meta data of a DBUS proxy interface.
 */
class ProxyMetadata
{
public:
   ProxyMetadata();
   ProxyMetadata(const ProxyMetadata& ref);
   ProxyMetadata& operator=(const ProxyMetadata& ref);
   bool operator==(const ProxyMetadata& ref) const;
   bool operator!=(const ProxyMetadata& ref) const;
   bool operator<(const ProxyMetadata& ref) const;
   bool operator>(const ProxyMetadata& ref) const;
   virtual ~ProxyMetadata();
   // member with public access
   ::std::string busName;
   ::std::string objPath;
   ::DBusBusType busType;
   ProxyUser user;

private:
   //inline void setUser(int value) { user = value; }
   int compare(const ProxyMetadata& ref) const;
};


} // namespace bosch
} // namespace org

#endif //_PROXY_METADATA_H
