/**
 * @file BluezAdapterProxyManager.h
 * @author RBEI/ECO3 Karthikeyan Madeswaran
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _BLUEZ_ADAPTER_PROXY_MANAGER_H
#define _BLUEZ_ADAPTER_PROXY_MANAGER_H

#include "ProxyManager.h"
#include "ProxyCallbacksManager.h"
#include "IBluezAdapterProxyIf.h"

namespace org
{
namespace bosch
{

//forward declarations

class BluezAdapterProxyManager: public ::asf::core::ServiceAvailableIF, public IBluezAdapterProxyIf
{
public:

    BluezAdapterProxyManager();

    virtual ~BluezAdapterProxyManager();

    // IBluezAdapterProxyIf implementation
    virtual void createProxy() override;

    virtual void destroyProxy() override;

    virtual bool isProxyServiceAvailable() override;

    virtual void setCallbackIf(ProxyUser user, IBluezAdapterNotifCallbackIf* callbackIf) override;

    // ServiceAvailableIF implementation
    virtual void onAvailable(const boost::shared_ptr < ::asf::core::Proxy >& proxy,
            const ::asf::core::ServiceStateChange& stateChange) override;

    virtual void onUnavailable(const boost::shared_ptr < ::asf::core::Proxy >& proxy,
            const ::asf::core::ServiceStateChange& stateChange) override;

    virtual act_t sendGetAddressRequest(IBluezAdapterNotifCallbackIf& callbackIf) override;
    virtual act_t sendGetAliasRequest(IBluezAdapterNotifCallbackIf& callbackIf) override;

    virtual bool getBluezAdapterAddress(::std::string& address) override;

    virtual void setBluezAdapterAddress(::std::string& address) override;
    virtual bool getBluezAdapterAlias(::std::string& alias) override;

    virtual void setBluezAdapterAlias(::std::string& alias) override;

protected:

private:

    ProxyManager < BluezAdpaterProxy > _proxyManager;
    ProxyCallbacksManager< IBluezAdapterNotifCallbackIf >  _proxyCbManager;
    ::std::string _bluezAdapterAddress;
    ::std::string _bluezAdapterAlias;

    DECLARE_CLASS_LOGGER();

};

} // namespace bosch
} // namespace org

#endif //_BLUEZ_ADAPTER_PROXY_MANAGER_H

/** @} */
