/**
 * @file DBusHelper.h
 * @author RBEI/ECO32 Karthikeyan Madeswaran
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 * @brief 
 *
 * @{
 */

#ifndef _DBUS_UTILS_H
#define _DBUS_UTILS_H

#include <string>

#include "asf/dbus/DBusTypes.h"
#include "asf/dbus/DBusVariant.h"

namespace org
{
namespace bosch
{

void dict_append_string_entry(DBusMessageIter *dict, const char *key, int type, void *val);
bool append_variant(DBusMessageIter *iter, int type, void *val);
bool dict_append_entry(DBusMessageIter *dict, const char *key, int type, void *val);
bool insert_map_element(::std::map < ::std::string, ::asf::dbus::DBusVariant >& map, const ::std::string& key, int type,
      void *val);
bool append_dict_entry_fixed_array(DBusMessageIter *iter, const char *property, void *value, int length);
void* getMemAlloc(size_t size);
void* getDbusIterValue(DBusMessageIter*);
bool init_variant(::asf::dbus::DBusVariant& variant, bool value);

} //namespace bosch
} //namespace org

#endif //_DBUS_UTILS_H
