/**
 * @file RegulatoryMethodFactory.h
 * @author RBEI/ECO3 Usman Sheik
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#include "RegulatoryGNSSMethod.h"
#include "Regulatory80211dMethod.h"
#include "RegulatoryMethodFactory.h"
#include "RegulatoryMCCMethod.h"

namespace org {
	namespace bosch {

cRegulatoryMethodFactory::cRegulatoryMethodFactory()
{
}

cRegulatoryMethodFactory::~cRegulatoryMethodFactory()
{
	std::vector <cRegulatoryMethod *>::iterator it;

	for (it = _regulatoryclients.begin(); it < _regulatoryclients.end(); it++)
		delete (*it);
}

int cRegulatoryMethodFactory::destroyRegMethod(eRegulatoryMethod_t method)
{
	bool found = false;
	std::vector <cRegulatoryMethod *>::iterator it;

	for (it = _regulatoryclients.begin(); it < _regulatoryclients.end(); it++) {
		if (method == (*it)->getRegMethod()) {
			found = true;
			break;
		}
	}

	if (found) {
		delete (*it);
		_regulatoryclients.erase (it);
		return 0;
	}

	return -ENOENT;
}

cRegulatoryMethod *cRegulatoryMethodFactory::getRegulatoryMethod(eRegulatoryMethod_t method)
{
	cRegulatoryMethod *regMethod = NULL;
	std::vector <cRegulatoryMethod *>::iterator it;

	for (it = _regulatoryclients.begin(); it < _regulatoryclients.end(); it++)
		if (method == (*it)->getRegMethod())
			return (*it);

	if (REGULATORY_METHOD_GNSS == method)
		regMethod = new cRegulatoryGNSSMethod();
	else if (REGULATORY_METHOD_80211D == method)
		regMethod = new cRegulatory80211dMethod();
	else if (REGULATORY_METHOD_MCC == method)
		regMethod = new cRegulatoryMCCMethod();

	if (regMethod)
		_regulatoryclients.push_back(regMethod);

	return regMethod;
}

cRegulatoryMethod *cRegulatoryMethodFactory::getRegulatoryMethodfromSrc(const cc_source_t src)
{
	std::vector <cRegulatoryMethod *>::iterator it;

	for (it = _regulatoryclients.begin(); it < _regulatoryclients.end(); it++)
		if (src == (*it)->getCCSourceInfo())
			return (*it);

	return NULL;
}

	}
}

/** @} */
