/**
 * @file GenlEvent.cpp
 * @author RBEI/ECO32 Usman Sheik
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief Main file for Wifi_Business_Logic.
 *
 *
 * @{
 */

#include "GenlEvent.h"

namespace org {
	namespace bosch {

cRegulatoryUpdate *GenlEventToRegulatoryUpdate(cGenlRegEvent *event)
{
	cRegulatoryUpdate *regUpdate;
	std::vector<cWifiChannel*> supportedChannels;
	std::vector<cWifiChannel*>::iterator it;
	std::vector<cWifiRadio*> attachedRadios;
	std::vector<cWifiRadio*>::iterator it3;
	std::vector<cWifiNetworkInterface*> supportedDevices;
	std::vector<cWifiNetworkInterface*>::iterator it2;
	::boost::ptr_vector<WifiNetInterface> netdevices;
	::boost::ptr_vector<WifiChannel> channels;
	::boost::ptr_vector<WifiRadio> radios;
	WifiRadio *radio;

	if (!event)
		return NULL;

	regUpdate = new cRegulatoryUpdate();
	if (!regUpdate)
		return NULL;

	regUpdate->setGlobal(static_cast<uint8_t>(event->getGlobal()));
	if (event->getGlobal()) {
		regUpdate->setCountry(event->getCountry());
		regUpdate->setInitiator(event->getInitiator());
		regUpdate->setRegtype(event->getType());
	}

	attachedRadios = event->getWifiRadios();
	for (it3 = attachedRadios.begin(); it3 < attachedRadios.end();
			++it3) {

		radio = new WifiRadio();
		if (!radio)
			continue;

		radio->setRadio((*it3)->getPhyName());
		radio->setRegDomain((*it3)->getRegDomain());
		radio->setSelfManaged((*it3)->getSelfManaged());
		radio->setIeee80211index((*it3)->getIndex());

		if ((*it3)->getSelfManaged()) {
			radio->setRegtype(
					static_cast<uint8_t>((*it3)->getType()));
			radio->setInitiator(
					static_cast<uint8_t>((*it3)->getInitiator()));
		}

		supportedDevices = (*it3)->getNetDevices();
		supportedChannels = (*it3)->getChannels();

		for (it2 = supportedDevices.begin();
				it2 < supportedDevices.end(); ++it2)
			netdevices.push_back(new WifiNetInterface((*it2)->getIndex(),
					(*it2)->getMacAddress(), (*it2)->getIfName()));
		radio->setNetdevices(netdevices);

		for (it = supportedChannels.begin();
				it < supportedChannels.end(); ++it)
			channels.push_back(new WifiChannel((*it)->getChannel(),
					(*it)->getFrequency(), (*it)->getFlags()));
		radio->setChannelsinfo(channels);

		radios.push_back(radio);
	}

	regUpdate->setRadios(radios);
	return regUpdate;
}

cGenlRegEvent *RegulatoryUpdateToGenlEvent(cRegulatoryUpdate *event)
{
	cGenlRegEvent *regUpdate;
	::boost::ptr_vector<WifiNetInterface> netdevices;
	::boost::ptr_vector<WifiNetInterface>::iterator it1;
	::boost::ptr_vector<WifiChannel> channels;
	::boost::ptr_vector<WifiChannel>::iterator it2;
	::boost::ptr_vector<WifiRadio> radios;
	::boost::ptr_vector<WifiRadio>::iterator it3;
	cWifiRadio *radio;

	if (!event)
		return NULL;

	regUpdate = new cGenlRegEvent();
	if (!regUpdate)
		return NULL;

	regUpdate->setGlobal(static_cast<bool>(event->getGlobal()));
	if (event->getGlobal()) {
		regUpdate->setCountry(event->getCountry());
		regUpdate->setInitiator(event->getInitiator());
		regUpdate->setType(event->getRegtype());
	}

	radios = event->getRadios();
	for (it3 = radios.begin(); it3 != radios.end();
			++it3) {

		radio = new cWifiRadio(it3->getIeee80211index(), it3->getRadio());
		if (!radio)
			continue;

		radio->setInitiator(it3->getInitiator());
		radio->setSelfManaged(it3->getSelfManaged());
		radio->setType(it3->getRegtype());
		radio->iSetRegDomain(it3->getRegDomain());

		netdevices = it3->getNetdevices();
		for (it1 = netdevices.begin(); it1 != netdevices.end(); ++it1)
			radio->bAddNetDevice(it1->getIndex(), it1->getMacaddress(),
					it1->getIfname());

		channels = it3->getChannelsinfo();
		for (it2 = channels.begin(); it2 != channels.end(); ++it2) {
			cWifiChannel channel(it2->getFrequency(), it2->getChannel(),
					it2->getFlags());
			radio->bAddWiFiChannel(&channel);
		}
		regUpdate->addWifiRadio(radio);
	}

	return regUpdate;
}

void genlEventCleanup(cGenlRegEvent **event)
{
	cGenlRegEvent *update;
	::std::vector <cWifiRadio *> radios;
	::std::vector <cWifiRadio *>::iterator it;

	if (!event || !*event)
		return;

	update = *event;
	radios = update->getWifiRadios();
	for (it = radios.begin(); it < radios.end(); ++it) {
		(*it)->bFlushNetDevs();
		(*it)->bFlushChannels();
		delete *it;
	}

	delete update;
	*event = nullptr;
}

cMlmeEventConnect *GenlEventToMlmeConnectEvent(cGenlMlmeConnectEvent *cevent)
{
	if (!cevent)
		return NULL;

	return new cMlmeEventConnect (cevent->getWiphyId(), cevent->getIfIndex(), cevent->getBssid(),
			cevent->getStatusCode(), cevent->getTimedout(), cevent->getIfname());
}

cMlmeEventDisconnect *GenlEventToMlmeDisConnectEvent(cGenlMlmeDisConnectEvent *devent)
{
	if (!devent)
		return NULL;

	return new cMlmeEventDisconnect (devent->getWiphyId(), devent->getIfIndex(), devent->isDisconnectedByAp(),
			devent->getReasonCode(), devent->getIfname());
}

	}
}

/** @} */
