/**
 * @file WpaSupplicantData.h
 * @author RBEI/ECO3 Usman Sheik
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _WPA_SUPPLICANT_DATA_H
#define _WPA_SUPPLICANT_DATA_H

#include <dbus/dbus.h>
#include "WBLUtils.h"

namespace org {
    namespace bosch {

#define WPA_SUPP_IFNAME_SET						BIT(1)
#define WPA_SUPP_ALPHA2_SET						BIT(2)
#define WPA_SUPP_STATE_SET						BIT(3)
#define WPA_SUPP_CURRENT_BSS_SET				BIT(4)
#define WPA_SUPP_CURRENT_NETWORK_SET			BIT(5)
#define WPA_SUPP_DISCONNECT_REASON_SET			BIT(6)

        typedef enum {
            WPA_SUPP_STATE_INVAL,
            WPA_SUPP_STATE_INACTIVE,
            WPA_SUPP_STATE_DISCONNECTED,
            WPA_SUPP_STATE_DISABLED,
            WPA_SUPP_STATE_SCANNING,
            WPA_SUPP_STATE_CONNECTING,
            WPA_SUPP_STATE_CONNECTED
        } eWpaSuppConnectionState_t;

        class cWpaSupplicantIfaceData final{

            int compare(const cWpaSupplicantIfaceData& ref) const {
                if (_BusType == ref._BusType && !_sIfName.compare(ref._sIfName)
                        && !_sObjPath.compare(ref._sObjPath))
                    return 0;
                return -1;
            }

        public:
            ::std::string _sIfName, _sObjPath, _sCountry, _state,
             _currentBSS, _currentNetwork;
            ::DBusBusType _BusType;
            int _disconnectReason;
            bool _wpaConnStatusDue;

            cWpaSupplicantIfaceData(::std::string &ifName,
                    const ::std::string &objPath, const ::DBusBusType busType) {
                _sIfName = ifName;
                _sObjPath = objPath;
                _BusType = busType;
                _BusType = static_cast< ::DBusBusType >(0);
                _disconnectReason = 0;
                _wpaConnStatusDue = false;
            }

            cWpaSupplicantIfaceData() {
                _BusType = static_cast< ::DBusBusType >(0);
                _disconnectReason = 0;
                _wpaConnStatusDue = false;
            }

            virtual ~cWpaSupplicantIfaceData() { }

            cWpaSupplicantIfaceData &operator=(const cWpaSupplicantIfaceData &ref) {
                if(this == &ref)
                    return *this;
                _sIfName = ref._sIfName;
                _sObjPath = ref._sObjPath;
                _BusType = ref._BusType;
                _sCountry = ref._sCountry;
                _state = ref._state;
                _currentBSS = ref._currentBSS;
                _currentNetwork = ref._currentNetwork;
                _disconnectReason = ref._disconnectReason;
                _wpaConnStatusDue = ref._wpaConnStatusDue;
                return *this;
            }

            bool operator==(const cWpaSupplicantIfaceData &ref) const {
                if (!compare(ref))
                    return true;
                return false;
            }

            bool operator!=(const cWpaSupplicantIfaceData &ref) const {
                if (!compare(ref))
                    return false;
                return true;
            }
        };

        class cWpaSupplicantConnectionNotifier {
        public:
            cWpaSupplicantConnectionNotifier() { }
            virtual ~cWpaSupplicantConnectionNotifier() { }
            static eWpaSuppConnectionState_t wpaStateToEvent(const ::std::string state) {
                if (state.empty())
                    return WPA_SUPP_STATE_INVAL;
                else if(!state.compare("inactive"))
                    return WPA_SUPP_STATE_INACTIVE;
                else if (!state.compare("disconnected"))
                    return WPA_SUPP_STATE_DISCONNECTED;
                else if (!state.compare("interface_disabled"))
                    return WPA_SUPP_STATE_DISABLED;
                else if (!state.compare("scanning"))
                    return WPA_SUPP_STATE_SCANNING;
                else if (!state.compare("authenticating") ||
                        !state.compare("associating") ||
                        !state.compare("associated") ||
                        !state.compare("4wai_handshake") ||
                        !state.compare("group_handshake"))
                    return WPA_SUPP_STATE_CONNECTING;
                else if (!state.compare("completed"))
                    return WPA_SUPP_STATE_CONNECTED;

                return WPA_SUPP_STATE_INVAL;
            }

            static ::std::string wpaStateToString(const eWpaSuppConnectionState_t state) {
                switch (state) {
                case WPA_SUPP_STATE_INVAL:
                    return "UNKNOWN";
                case WPA_SUPP_STATE_INACTIVE:
                    return "INACTIVE";
                case WPA_SUPP_STATE_DISCONNECTED:
                    return "DISCONNECTED";
                case WPA_SUPP_STATE_DISABLED:
                    return "INTERFACE_DISABLED";
                case WPA_SUPP_STATE_SCANNING:
                    return "SCANNING";
                case WPA_SUPP_STATE_CONNECTING:
                    return "CONNECTING";
                case WPA_SUPP_STATE_CONNECTED:
                    return "CONNECTED";
                }
                return "UNKNOWN";
            }

            virtual void wpaConnectionNotification(eWpaSuppConnectionState_t state, const ::std::string &ifName,
                    const ::std::string &associatedbss) = 0;
            virtual void wpaDisconnectionStatus(int status, const ::std::string &ifName) = 0;
        };

    }
}

#endif //_WPA_SUPPLICANT_DATA_H

/** @} */
