/**
 * @file WpaSupplicantClient.h
 * @author RBEI/ECO3 Usman Sheik
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */
#ifndef _WPA_SUPPLICANT_CLIENT_H
#define _WPA_SUPPLICANT_CLIENT_H

#include "asf/core/Logger.h"
#include "LoopbackTypes.h"
#include "GenericSingleton.h"
#include "IWpaSupplicantNotifCallbackIf.h"
#include "IWpaSupplicantIfaceNotifCallbackIf.h"
#include "IOrgFreedesktopDBusNotifCallbackIf.h"
#include "IWpaSupplicantBssNotifCallbackIf.h"
#include "BasicServiceSet.h"
#include "ProxyTypes.h"
#include "RegulatoryChannelAvailability.h"
#include "WpaSupplicantData.h"

namespace org {
    namespace bosch {

        class cIWpaSupplicantProxyIf;
        class cIWpaSupplicantIfaceProxyIf;
        class cIOrgFreedesktopDBusPropertiesProxyIf;
        class cBasicServiceSet;
        class cBSSNotifier;
        class cISO3166CountryInfo;

        class cWpaSupplicantClient final:
        public cIWpaSupplicantNotifCallbackIf,
        public cIWpaSupplicantIfaceNotifCallbackIf,
        public cIOrgFreedesktopDBusPropertiesNotifCallbackIf,
        public cIWpaSupplicantBssNotifCallbackIf,
        public cGetIfaceCbIf,
        public cDBusPropGetCbIf,
        public cDBusPropSetCbIf,
        public cDBusPropGetAllCbIf,
        public cRegulatoryChannel,
        public GenericSingleton<cWpaSupplicantClient> {

        public:

            virtual ~cWpaSupplicantClient();

            virtual void onWpaSupplicantServiceAvailable(const ::std::string &busName,
                    const ::std::string &objPath, const ::DBusBusType busType,
                    const ::asf::core::ServiceState previousState, const ::asf::core::ServiceState currentState) override;
            virtual void onWpaSupplicantServiceUnavailable(const ::std::string &busName,
                    const ::std::string &objPath, const ::DBusBusType busType,
                    const ::asf::core::ServiceState previousState, const ::asf::core::ServiceState currentState) override;
            virtual void onInterfaceAddedError(const ::boost::shared_ptr< cWpaSupplicantProxy > &proxy,
                    const ::boost::shared_ptr< cIfaceAddedError > &error) override;
            virtual void onInterfaceAddedSignal(const ::boost::shared_ptr< cWpaSupplicantProxy > &proxy,
                    const ::boost::shared_ptr< cIfaceAddedSignal > &signal) override;
            virtual void onInterfaceRemovedError(const ::boost::shared_ptr< cWpaSupplicantProxy > &proxy,
                    const ::boost::shared_ptr< cIfaceRemovedError > &error) override;
            virtual void onInterfaceRemovedSignal(const ::boost::shared_ptr< cWpaSupplicantProxy > &proxy,
                    const ::boost::shared_ptr< cIfaceRemovedSignal > &signal) override;
            virtual void onGetInterfaceError(const ::boost::shared_ptr< cWpaSupplicantProxy > &proxy,
                    const ::boost::shared_ptr< cGetIfaceError > &error) override;
            virtual void onGetInterfaceResponse(const ::boost::shared_ptr< cWpaSupplicantProxy > &proxy,
                    const ::boost::shared_ptr< cGetIfaceResponse > &response) override;

            virtual void onWpaSupplicantIfaceServiceAvailable(const ::std::string &busName,
                    const ::std::string &objPath, const ::DBusBusType busType,
                    const ::asf::core::ServiceState previousState, const ::asf::core::ServiceState currentState) override;
            virtual void onWpaSupplicantIfaceServiceUnavailable(const ::std::string &busName,
                    const ::std::string &objPath, const ::DBusBusType busType,
                    const ::asf::core::ServiceState previousState, const ::asf::core::ServiceState currentState) override;
            virtual void onBSSAddedError(const ::boost::shared_ptr< cWpaSupplicantIfaceProxy > &proxy,
                    const ::boost::shared_ptr< cBssAddedError > &error) override;
            virtual void onBSSAddedSignal(const ::boost::shared_ptr< cWpaSupplicantIfaceProxy > &proxy,
                    const ::boost::shared_ptr< cBssAddedSignal > &signal) override;
            virtual void onBSSRemovedError(const ::boost::shared_ptr< cWpaSupplicantIfaceProxy > &proxy,
                    const ::boost::shared_ptr< cBssRemovedError > &error) override;
            virtual void onBSSRemovedSignal(const ::boost::shared_ptr< cWpaSupplicantIfaceProxy > &proxy,
                    const ::boost::shared_ptr< cBssRemovedSignal > &signal) override;

            virtual void onWpaSupplicantBssServiceAvailable(const ::std::string &busName,
                    const ::std::string &objPath, const ::DBusBusType busType,
                    const ::asf::core::ServiceState previousState,
                    const ::asf::core::ServiceState currentState) override;
            virtual void onWpaSupplicantBssServiceUnAvailable(const ::std::string &busName,
                    const ::std::string &objPath, const ::DBusBusType busType,
                    const ::asf::core::ServiceState previousState,
                    const ::asf::core::ServiceState currentState) override;

            virtual void onGetError(const ::boost::shared_ptr< cDBusPropertiesProxy > &proxy,
                    const ::boost::shared_ptr< cDBusPropGetError > &error) override;
            virtual void onGetResponse(const ::boost::shared_ptr< cDBusPropertiesProxy > &proxy,
                    const ::boost::shared_ptr< cDBusPropGetResponse >& response) override;
            virtual void onGetAllError(const ::boost::shared_ptr< cDBusPropertiesProxy > &proxy,
                    const ::boost::shared_ptr< cDBusPropGetAllError >& error) override;
            virtual void onGetAllResponse(const ::boost::shared_ptr< cDBusPropertiesProxy > &proxy,
                    const ::boost::shared_ptr< cDBusPropGetAllResponse > &response) override;
            virtual void onSetError(const ::boost::shared_ptr< cDBusPropertiesProxy > &proxy,
                    const ::boost::shared_ptr< cDBusPropSetError >& error) override;
            virtual void onSetResponse(const ::boost::shared_ptr< cDBusPropertiesProxy > &proxy,
                    const ::boost::shared_ptr< cDBusPropSetResponse >& response) override;
            virtual void onPropertiesChangedError(const ::boost::shared_ptr< cDBusPropertiesProxy > &proxy,
                    const ::boost::shared_ptr< cDBusPropChangedError > &error) override;
            virtual void onPropertiesChangedSignal(const ::boost::shared_ptr<cDBusPropertiesProxy> &proxy,
                    const ::boost::shared_ptr< cDBusPropChangedSignal > &signal) override;

            virtual void onDisconnectError(const ::boost::shared_ptr< cWpaSupplicantIfaceProxy >& proxy,
                    const ::boost::shared_ptr< cWpaDisconnectError >& error) override;
            virtual void onDisconnectResponse(const ::boost::shared_ptr< cWpaSupplicantIfaceProxy >& proxy,
                    const ::boost::shared_ptr< cWpaDisconnectResponse >& response) override;

            int registerBSSNotification(cBSSNotifier *listener);
            int unRegisterBSSNotification(cBSSNotifier *listener);

            int registerWpaConnectionNotification(cWpaSupplicantConnectionNotifier *listener);
            int unRegisterWpaConnectionNotification(cWpaSupplicantConnectionNotifier *listener);

            ::std::vector< cBasicServiceSet > &getBSSes();
            ::std::string getConnectedBss(const ::std::string ifName);
            cBasicServiceSet *getBSSFromObjectPath(const ::std::string &path);
            int changeRegulatory(const ::std::string &country) override;
            int disconnectBss(const ::std::string &bss);
            int getBssFromMacAddr(const std::string &macaddr, ::std::string &objpath);

        private:

            friend class GenericSingleton<cWpaSupplicantClient>;

            bool _wpaSuppIfaceServiceAvailability;
            ::std::vector< cBasicServiceSet > _wpaSupplicantBssProxies;
            ::std::vector< cBSSNotifier* > _bssNotifierClients;
            ::std::vector< cWpaSupplicantConnectionNotifier* > _wpaConnectionNotifierClients;
            ::std::vector< cWpaSupplicantIfaceData > _wpaSupplicantIfaceProxies;

            int deregisterBSSProxy(cBasicServiceSet &bss);
            int deregisterWpaSupplicantProxy(const cWpaSupplicantIfaceData &iface);
            int removeBSSdata(cBasicServiceSet &bss);
            int removeWpaSuppIfacedata(cWpaSupplicantIfaceData &iface);

            void updateBSSNotification(eBssEvent_t event, const ::std::string &objPath,
                    const cBasicServiceSet &bss);
            void updateWpaConnectionStatus(eWpaSuppConnectionState_t state, const ::std::string &ifname,
                    const ::std::string &associatedBss);
            void updateWpaDisconnectionStatus(int status, const ::std::string &ifName);

            void notifyWpaSupplicantAvailabilityStatus();

            int createWpaSuppIfaceProxy(const ::std::string &objPath, const ::DBusBusType &busType,
                    eProxyType eType);
            int createWpaSuppProxy(const ::std::string &objPath, const ::DBusBusType &busType,
                    eProxyType eType);
            int createWpaSuppBssProxy(const ::std::string &objPath, const ::DBusBusType &busType,
                    eProxyType eType);
            cIOrgFreedesktopDBusPropertiesProxyIf *createDbusPropProxy(const ::std::string &portName,
                    const ::std::string &busName, const ::std::string &objPath,
                    const ::DBusBusType &busType, eProxyType eType);
            int getWpaSupplicantData(const ::std::string &objPath, const ::DBusBusType &busType,
                    cWpaSupplicantIfaceData **wpaData);
            cWpaSupplicantIfaceData *getWpaSupplicantfromIfName(const ::std::string &name);
            int getWpaSupplicantBssData(const ::std::string &objPath, const ::DBusBusType &busType,
                    cBasicServiceSet **bssData);
            int getCountryElemfromIEs(const uint8 *ielements, const int &length,
                    const int element_id, ::std::string &country);

            int getBssKeyManagement(::DBusMessageIter *iter, uint32_t *keyMgmt);
            void fillWpaSuppData(cWpaSupplicantIfaceData *data, int type, const void *response);
            void fillBssData(cBasicServiceSet *bss, int type, const void *response);

            cWpaSupplicantClient();
            cWpaSupplicantClient(const cWpaSupplicantClient& ref);
            cWpaSupplicantClient& operator=(const cWpaSupplicantClient& ref);

            DECLARE_CLASS_LOGGER();
        };

    } //namespace bosch
} //namespace org

#endif //_WPA_SUPPLICANT_CLIENT_H

/** @} */
