/**
 * @file WifiMlmeUpdates.h
 * @author RBEI/ECO32 Usman Sheik
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 *
 * @{
 */

#ifndef _WIFI_MLME_UPDATES_H
#define _WIFI_MLME_UPDATES_H

#include <string>
#include <vector>
#include "LoopbackTypes.h"
#include "GenericSingleton.h"
#include "WBLUtils.h"
#include "asf/core/Logger.h"

namespace org {
    namespace bosch {

        class cWifiMlmeConnectionDetails final{
        public:
            unsigned int _wiphyid, _ifindex;
            ::std::string _currentBss, _macaddr, _ifname;
            bool _isDue;
            cWifiMlmeConnectionDetails() : _wiphyid(0), _ifindex(0), _isDue(false) { }
            virtual ~cWifiMlmeConnectionDetails() { }
            void clear() {
                _currentBss.clear();
                _macaddr.clear();
                _ifname.clear();
                _wiphyid = _ifindex = 0;
            }
            bool operator==(const cWifiMlmeConnectionDetails &ref) const {
                if (_wiphyid == ref._wiphyid && _ifindex == ref._ifindex &&
                        !_ifname.compare(_ifname))
                    return true;
                return false;
            }
        };

        class cWifiMlmeConnectionObserver {
        public:
            cWifiMlmeConnectionObserver() { }
            virtual ~cWifiMlmeConnectionObserver() { }
            virtual void MlmeConnected(const ::std::string &ifName, const ::std::string &associatedBss,
                    const unsigned int &ifindex, const ::std::string &macaddr) = 0;
            virtual void MlmeDisConnected(const ::std::string &ifName, const ::std::string &disconnectedBss) = 0;
        };

        class cWifiMlmeNotifier {
        private:
            ::std::vector< cWifiMlmeConnectionObserver* > _mlmeObservers;
        public:
            cWifiMlmeNotifier();
            virtual ~cWifiMlmeNotifier();
            virtual int registerForMlmeUpdates(cWifiMlmeConnectionObserver *client) final;
            virtual int unRegisterForMlmeUpdates(cWifiMlmeConnectionObserver *client) final;
            virtual void updateMlmeStatus(bool connected, const ::std::string &ifname,const ::std::string &associatedBss,
                    const unsigned int &ifindex,const ::std::string &macaddr);
        };

        class cWifiMlmeUpdates final:
        public cWifiMlmeNotifier,
        public GenericSingleton<cWifiMlmeUpdates> {
            DECLARE_CLASS_LOGGER();
        private:
            cWifiMlmeUpdates();
            friend class GenericSingleton<cWifiMlmeUpdates>;
            ::std::vector<cWifiMlmeConnectionDetails> _mlmeStatus;
            cWifiMlmeConnectionDetails *getMlmeConnectionDetails(unsigned int wiphyid, unsigned int ifindex,
                    const ::std::string &ifname);
            int addMlmeConnectionDetails(unsigned int wiphyid, unsigned int ifindex,
                    const ::std::string &ifname, const ::std::string &mac);
            int removeMlmeConnectionDetails(unsigned int wiphyid, unsigned int ifindex,
                    const ::std::string &ifname);
        public:
            virtual ~cWifiMlmeUpdates();
            void mlmeConnected(const cMlmeEventConnect &cevent);
            void mlmeDisConnected(const cMlmeEventDisconnect &devent);
        };

    }
}

#endif //_WIFI_MLME_UPDATES_H

/** @} */
