/**
 * @file WatchDog.h
 * @author RBEI/ECO3 Usman Sheik
 * @copyright (c) 2018 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _WATCH_DOG_H
#define _WATCH_DOG_H

#include <time.h>
#include <vector>
#include "asf/core/Timer.h"
#include "asf/core/Logger.h"

namespace org {
	namespace bosch {

#define REGULATORY_DOMAIN_WATCH_DOG_TIMER_MIN	2 * 60 * 1000	//2 mins default
#define REGULATORY_DOMAIN_WATCH_DOG_TIMER_MAX	60 * 60 * 1000	//one hour default

typedef enum _timer_type {
	eWatchDog_Type_Periodic = 0,
	eWatchDog_Type_Once
} wttype_t;

class cWatchDogCallbackIf {
public:
	virtual ~cWatchDogCallbackIf() { }
	virtual void watchDogExpired(void *data) = 0;
};

class cWatchDog : public ::asf::core::TimerCallbackIF {
	wttype_t _type;
	unsigned int _interval;
	::asf::core::Timer *_watchDog;
	::std::vector<cWatchDogCallbackIf*> _callbacks;
	DECLARE_CLASS_LOGGER();
protected:
	void notify(void *data);
	virtual int startWatchDog();
	virtual int stopWatchDog();
	bool createTimer();
	void destroyTimer();
	int setTimeInterval(const unsigned int interval);
	unsigned int getWatchDogInterval();
public:
	int subscribe(cWatchDogCallbackIf *cb);
	int unsubscribe(cWatchDogCallbackIf *cb);
	static const std::string watchDogTypeToString(const wttype_t type);
	explicit cWatchDog(const wttype_t type);
	cWatchDog(const cWatchDog &r) = delete;
	const cWatchDog &operator=(const cWatchDog &r) = delete;
	virtual ~cWatchDog();
	virtual int start () = 0;
	virtual int stop(bool reset) = 0;
	virtual void expired(::boost::shared_ptr< ::asf::core::TimerPayload > data) = 0;
	virtual void onExpired(::asf::core::Timer& timer, ::boost::shared_ptr< ::asf::core::TimerPayload > data);
};

class cRegulatoryWatchDog : public cWatchDog {
	unsigned int _timeLeft, _timeToWatch;
	struct timespec _startTime;
	int getWatchDogConfigurations(const ::std::string &key, unsigned int &data);
	int setWatchDogConfigurations(const ::std::string &key, unsigned int &data);
	void removeOldKeys();
	DECLARE_CLASS_LOGGER();
public:
	cRegulatoryWatchDog();
	~cRegulatoryWatchDog();
	int start () override;
	int stop(bool reset) override;
	virtual void expired(::boost::shared_ptr< ::asf::core::TimerPayload > data) override;
};

}
}

#endif //_WATCH_DOG_H

/** @} */
