/**
 * @file RegulatoryGNSSMethod.h
 * @author RBEI/ECO3 Usman Sheik
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _REGULATORY_GNSS_METHOD_H
#define _REGULATORY_GNSS_METHOD_H

#include "asf/core/Logger.h"
#include "RegulatoryMethod.h"
#include "NavigationClient.h"

namespace org
{
    namespace bosch
    {

        class cRegulatoryChangeNotifier;
        class cNavigationUpdateNotifier;

        class cRegulatoryGNSSMethod final: public cRegulatoryMethod,  public cCountryChangeUpdate
        {

            DECLARE_CLASS_LOGGER();
        private:
            bool _notify, _countryUpdateAvailability;
            cNavigationClient *_navclient;
            void setCountryChangeUpdateChannel();
            void updateCountryCodeInfo();
        public:
            cRegulatoryGNSSMethod();
            cRegulatoryGNSSMethod(const cRegulatoryGNSSMethod& ref);
            cRegulatoryGNSSMethod& operator=(const cRegulatoryGNSSMethod& ref);
            cRegulatoryGNSSMethod(cRegulatoryChangeNotifier *observer);
            virtual ~cRegulatoryGNSSMethod();
            virtual int start() override;
            virtual int stop() override;
            virtual void countryChangeUpdate(const ::std::string &country) override;
            virtual void countryChangeAvailability(bool availability) override;
            void checkServiceAvailability();
            virtual void setCountryCodeInfo (const cc_availability_t serAvail, const ::std::string &cc, const uint16_t numeric);
        };

    }
}

#endif //_REGULATORY_GNSS_METHOD_H

/** @} */
