/**
 * @file Regulatory80211dMethod.h
 * @author RBEI/ECO3 Usman Sheik
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _REGULATORY_80211D_METHOD_H
#define _REGULATORY_80211D_METHOD_H

#include "asf/core/Logger.h"
#include "RegulatoryMethod.h"
#include "BasicServiceSet.h"
#include "RegulatoryChannelAvailability.h"

namespace org {
    namespace bosch {

        class cRegulatoryChangeNotifier;

        class cCountryGroup {
        public:
            ::std::string _country;
            ::std::vector< ::std::string > _BSSs;
            unsigned int _count;
            bool operator < (const cCountryGroup &obj) const {
                if (_count < obj._count)
                    return true;
                return false;
            }
            cCountryGroup() {
                _count = 0;
            }
            ~cCountryGroup() {}
        };

        class cRegulatory80211dMethod :
                public cRegulatoryMethod,
                public cBSSNotifier,
                public cRegChannelAvailability {
        private:
            DECLARE_CLASS_LOGGER();
            bool _registered;
            bool _notify;
        protected:
            cCountryGroup *getCountry(::std::vector<cCountryGroup> &BSSs, const ::std::string &country);
            void dumpCountryDetails(::std::vector<cCountryGroup> &BSSs);
            void updateCountryChange(::std::vector<cCountryGroup> &BSSs);
        public:
            cRegulatory80211dMethod();
            cRegulatory80211dMethod(cRegulatoryChangeNotifier *observer);
            virtual ~cRegulatory80211dMethod();

            virtual int start() override;
            virtual int stop() override;
            virtual void BSSNotification(eBssEvent_t event, const ::std::string &objPath,
                    const cBasicServiceSet &bss) override;
            virtual void notifyRegChannelAvailabilty(const eRegChannelType_t type,
                    const bool availability) override;
        };

    }
}

#endif //_REGULATORY_80211D_METHOD_H

/** @} */
