/**
 * @file NetlinkSocket.h
 * @author RBEI/ECO32 Usman Sheik
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief Main file for Wifi_Business_Logic.
 *
 *
 * @{
 */

#ifndef _NETLINK_SOCKET_H
#define _NETLINK_SOCKET_H

#include <vector>
#include <string>
#include "asf/core/Logger.h"

struct nl_sock;
struct nl_cb;
struct sockaddr_nl;
struct nl_msg;

namespace org {
	namespace bosch {

class cNlObserver;
class cNlMessage;

typedef enum {
	NL_SOCKET_TYPE_ROUTE,
	NL_SOCKET_TYPE_UNUSED,
	NL_SOCKET_TYPE_USERSOCK,
	NL_SOCKET_TYPE_FIREWALL,
	NL_SOCKET_TYPE_SOCK_DIAG,
	NL_SOCKET_TYPE_NFLOG,
	NL_SOCKET_TYPE_XFRM,
	NL_SOCKET_TYPE_SELINUX,
	NL_SOCKET_TYPE_ISCSI,
	NL_SOCKET_TYPE_AUDIT,
	NL_SOCKET_TYPE_FIB_LOOKUP,
	NL_SOCKET_TYPE_CONNECTOR,
	NL_SOCKET_TYPE_NETFILITER,
	NL_SOCKET_TYPE_IP6_FW,
	NL_SOCKET_TYPE_DNRTMSG,
	NL_SOCKET_TYPE_KOBJ_UEVENT,
	NL_SOCKET_TYPE_GENERIC,
	NL_SOCKET_TYPE_SCSITRANSPORT,
	NL_SOCKET_TYPE_ECRYPTFS,
	NL_SOCKET_TYPE_RDMA,
	NL_SOCKET_TYPE_CRYPTO
} eNlSocketType;

class cNetLink {

protected:
    int &iGetUnixSocket();
    struct nl_cb *pGetNlCB();
    struct nl_sock *pGetNlSock();
    int iGetRealNlSockType(const eNlSocketType &eType);
    const std::string sNlSockToString(const eNlSocketType &eType);
    static int iGenericErrorHandler(struct sockaddr_nl *nla,
    		struct nlmsgerr *err, void *arg);
    static int iGenericFinishHandler(struct nl_msg *msg, void *arg);
    static int iGenericAckHandler(struct nl_msg *msg, void *arg);
    static int iGenericSeqCheckHandler(struct nl_msg *msg, void *arg);
    void vNotifyObservers(cNlMessage *msg);
    int getSocketType();

public:
	virtual ~cNetLink();
	explicit cNetLink(const eNlSocketType eType);
	virtual int iStartWatch() = 0;
	int iRegisterForNlEvents(cNlObserver *observer);
	int iUnRegisterFromNlEvents(cNlObserver *observer);

private:
    int m_iRealNlSk;
    struct nl_sock *m_pNetlinkSk;
    struct nl_cb *m_pNetlinkCb;
    eNlSocketType m_eSkType;
    std::vector<cNlObserver *> _nleventobservers;

    int bInitializeNlChannel(const eNlSocketType &eType);
    int bInitializeNlCB();
	DECLARE_CLASS_LOGGER();
};

	}
}

#endif //_NETLINK_SOCKET_H

/** @} */
