/**
 * @file NetlinkObserver.h
 * @author RBEI/ECO32 Usman Sheik
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief Main file for Wifi_Business_Logic.
 *
 *
 * @{
 */

#ifndef _NL_OBSERVER_H
#define _NL_OBSERVER_H

#include "NetlinkEvent.h"

namespace org {
	namespace bosch {

class cNlMessage;

class cNlObserver {
	eNlMessageType_t _msgType;
public:
	eNlMessageType_t &getMessageType() {
		return _msgType;
	}
	explicit cNlObserver(eNlMessageType_t type) {
		_msgType = type;
	}
	virtual ~cNlObserver() {};
	virtual void bNetlinkEvent(cNlMessage *msg) = 0;
};

	}
}

#endif //_NL_OBSERVER_H

/** @} */
