/**
 * @file NetlinkEvent.h
 * @author RBEI/ECO32 Usman Sheik
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief .
 *
 *
 * @{
 */

#ifndef _NL_EVENT_H
#define _NL_EVENT_H

namespace org {
	namespace bosch {

typedef enum {
	NL_MESSAGE_TYPE_ROUTE,
	NL_MESSAGE_TYPE_UNUSED,
	NL_MESSAGE_TYPE_USERSOCK,
	NL_MESSAGE_TYPE_FIREWALL,
	NL_MESSAGE_TYPE_SOCK_DIAG,
	NL_MESSAGE_TYPE_NFLOG,
	NL_MESSAGE_TYPE_XFRM,
	NL_MESSAGE_TYPE_SELINUX,
	NL_MESSAGE_TYPE_ISCSI,
	NL_MESSAGE_TYPE_AUDIT,
	NL_MESSAGE_TYPE_FIB_LOOKUP,
	NL_MESSAGE_TYPE_CONNECTOR,
	NL_MESSAGE_TYPE_NETFILITER,
	NL_MESSAGE_TYPE_IP6_FW,
	NL_MESSAGE_TYPE_DNRTMSG,
	NL_MESSAGE_TYPE_KOBJ_UEVENT,
	NL_MESSAGE_TYPE_GENERIC,
	NL_MESSAGE_TYPE_SCSITRANSPORT,
	NL_MESSAGE_TYPE_ECRYPTFS,
	NL_MESSAGE_TYPE_RDMA,
	NL_MESSAGE_TYPE_CRYPTO
} eNlMessageType_t;

class cNlMessage {
	eNlMessageType_t nlMsgId;
public:
	eNlMessageType_t getNlMessageId() {
		return nlMsgId;
	}
protected:
	explicit cNlMessage(const eNlMessageType_t type) {
		nlMsgId = type;
	}
	virtual ~cNlMessage() {}
};

	}
}

#endif// _NL_EVENT_H

/** @} */
