/**
 * @file LoopbackClient.h
 * @author RBEI/ECO3 Usman Sheik
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */
#ifndef _LOOPBACK_CLIENT_H
#define _LOOPBACK_CLIENT_H

#include "asf/core/Logger.h"
#include "LoopbackTypes.h"
#include "ILoopbackNotifCallbackIf.h"
#include "ProxyTypes.h"
#include "GenericSingleton.h"

namespace org {
	namespace bosch {

class cLoopbackClient final:
		public cILoopbackNotifCallbackIf,
		public GenericSingleton<cLoopbackClient> {

public:

	virtual ~cLoopbackClient();

	virtual void onLoopbackServiceAvailable(const ::boost::shared_ptr< cWBLASFServiceProxy >& proxy,
			const ::asf::core::ServiceState previousState,
			const ::asf::core::ServiceState currentState) override;
	virtual void onLoopbackServiceUnAvailable(const ::boost::shared_ptr< cWBLASFServiceProxy >& proxy,
			const ::asf::core::ServiceState previousState,
			const ::asf::core::ServiceState currentState) override;
	virtual void onStarteventloopResponse(const ::boost::shared_ptr< cWBLASFServiceProxy > &proxy,
			const ::boost::shared_ptr< cStarteventloopResponse > &response) override;
	virtual void onStarteventloopError(const ::boost::shared_ptr< cWBLASFServiceProxy >& proxy,
			const ::boost::shared_ptr< cStarteventloopError >& error) override;
	virtual void onSetpropertyResponse(const ::boost::shared_ptr< cWBLASFServiceProxy >& proxy,
			const ::boost::shared_ptr< cSetpropertyResponse >& response) override;
	virtual void onSetpropertyError(const ::boost::shared_ptr< cWBLASFServiceProxy >& proxy,
			const ::boost::shared_ptr< cSetpropertyError >& error) override;
	virtual void onRegulatoryupdateRegisterConfirmation(const ::boost::shared_ptr< cWBLASFServiceProxy >& proxy) override;
	virtual void onCurrentRegSettingsGetUpdate(const ::boost::shared_ptr< cWBLASFServiceProxy >& proxy,
			const ::boost::shared_ptr< cCurrentRegSettingsUpdate >& update) override;
	virtual void onCurrentRegSettingsUpdate(const ::boost::shared_ptr< cWBLASFServiceProxy >& proxy,
			const ::boost::shared_ptr< cCurrentRegSettingsUpdate >& update) override;
	virtual void onCurrentRegSettingsRegisterError(const ::boost::shared_ptr< cWBLASFServiceProxy >& proxy,
			const ::boost::shared_ptr< cCurrentRegSettingsRegisterError >& error) override;
	virtual void onCurrentRegSettingsGetError(const ::boost::shared_ptr< cWBLASFServiceProxy >& proxy,
			const ::boost::shared_ptr< cCurrentRegSettingsGetError >& error) override;
	virtual void onMediaConnectedGetUpdate(const ::boost::shared_ptr< cWBLASFServiceProxy >& proxy,
			const ::boost::shared_ptr< cMediaConnectedUpdate >& update) override;
	virtual void onMediaConnectedUpdate(const ::boost::shared_ptr< cWBLASFServiceProxy >& proxy,
			const ::boost::shared_ptr< cMediaConnectedUpdate >& update) override;
	virtual void onMediaConnectedRegisterError(const ::boost::shared_ptr< cWBLASFServiceProxy >& proxy,
			const ::boost::shared_ptr< cMediaConnectedRegisterError >& error) override;
	virtual void onMediaConnectedGetError(const ::boost::shared_ptr< cWBLASFServiceProxy >& proxy,
			const ::boost::shared_ptr< cMediaConnectedGetError >& error) override;
	virtual void onMediaDisconnectedGetUpdate(const ::boost::shared_ptr< cWBLASFServiceProxy >& proxy,
			const ::boost::shared_ptr< cMediaDisconnectedUpdate >& update) override;
	virtual void onMediaDisconnectedUpdate(const ::boost::shared_ptr< cWBLASFServiceProxy >& proxy,
			const ::boost::shared_ptr< cMediaDisconnectedUpdate >& update) override;
	virtual void onMediaDisconnectedRegisterError(const ::boost::shared_ptr< cWBLASFServiceProxy >& proxy,
			const ::boost::shared_ptr< cMediaDisconnectedRegisterError >& error) override;
	virtual void onMediaDisconnectedGetError(const ::boost::shared_ptr< cWBLASFServiceProxy >& proxy,
			const ::boost::shared_ptr< cMediaDisconnectedGetError >& error) override;

private:
	bool __eventLoopStartRequested;
	cLoopbackClient();
	friend class GenericSingleton<cLoopbackClient>;
	DECLARE_CLASS_LOGGER();
};

	}
}

#endif //_LOOPBACK_CLIENT_H

/** @} */
