/**
 * @file GenericNetlink.h
 * @author RBEI/ECO32 Usman Sheik
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief Main file for Wifi_Business_Logic.
 *
 *
 * @{
 */

#ifndef _GENERIC_NETLINK_H
#define _GENERIC_NETLINK_H

#include <linux/nl80211.h>
#include "asf/core/Logger.h"
#include "GenericSingleton.h"
#include "Poller.h"
#include "NetlinkSocket.h"

struct nl_msg;
struct nlattr;
struct nl_sock;
typedef int (*iEventhandler) (struct nl_msg *, void *);

namespace org {
	namespace bosch {

class cNetLink;
class cIOChannel;
class cWifiChannel;
class cWifiRadio;
class cWifiNetworkInterface;
class cGenlMessage;

class cGenlFamilyResolver {
	std::string m_sFamily;
	int m_iIdentity;
public:
	const std::string &sGetGenlFamily();
	int iSetGenlFamily(const std::string &sGenlFamily);
	const int &iGetGenlResolver();
	int iSetGenlResolver(const int &iResolver);
	cGenlFamilyResolver(const std::string &sGenlFamily);
	cGenlFamilyResolver();
	~cGenlFamilyResolver();
};

class cGenNetLink final:
		public GenericSingleton<cGenNetLink>,
		public cNetLink,
		public cIOChannel {

public:
    int iStartWatch() override;
    virtual ~cGenNetLink();
    bool bProcessEvent(int iPollFd, int iEvent) override;
    std::vector <cWifiRadio*> & getRadios();
    void vTriggerUpdate();

protected:
    static int iProcessGenlEvent(struct nl_msg *msg, void *arg);
    static int iProcessRegEvent(struct nlattr **attr, void *arg);
    static int iProcessFamResolveEvent (struct nl_msg *msg, void *data);
    static const std::string sConvertGenlEventToString(enum nl80211_commands eGeNlEvt);
    static const std::string sRegInitiatorToString(enum nl80211_reg_initiator eInitiator);
    static const std::string eRegChangeTypeToString(enum nl80211_reg_type eType);
    static ::asf::core::Logger &oGetLogger();
    static int iGenlErrorHandler(struct sockaddr_nl *nla, struct nlmsgerr *err, void *arg);
    static int iGenlFinishHandler(struct nl_msg *msg, void *arg);
    static int iGenlAckHandler(struct nl_msg *msg, void *arg);
    static int iGenlSeqCheckHandler(struct nl_msg *msg, void *arg);
    static int iExtractWiphyInfo(struct nl_msg *msg, void *arg);
    static int iExtractChannelInfo(struct nlattr *band, cWifiRadio **radio);
    static int iExtractInterfaceinfo(struct nl_msg *msg, void *arg);
    static cWifiChannel *getChannel(struct nlattr **tb);
    static int convertFreqToChannel(uint32_t freq, uint32_t *chan);
    int iGenlSendRecv(struct nl_sock *sk, struct nl_msg *msg, iEventhandler handler, void *data);
    int iGenlRequest(bool event_socket, enum nl80211_commands cmd, int flags, iEventhandler handler);
    int iGenlRequest(struct nl_msg *msg, iEventhandler handler);
    struct nl_sock *createNlSocket();
    void WifiRadioDump();
    cWifiRadio *getWifiRadio(int index);
    int addNetDevice(cWifiRadio *radio, uint32_t index, uint8_t *addr, const ::std::string &name);
    cWifiRadio *getWifiRadio(int index, const std::string &name);
    void notifyRegChange(bool global, cWifiRadio *radio);
    void notifyMlmeEvent(cGenlMessage *event);
    static int iExtractMlmeConnectInfo(struct nlattr **tb, void *arg);
    static int iExtractMlmeDisconnectInfo(struct nlattr **tb, void *arg);
    void updateRegulatoryData(u_int8_t initiator, u_int8_t type, const std::string &country);

    int getRegulatorySettings();
    int getRadioSettings(cWifiRadio *radio, int cmd, int flags);
    bool isWiphyDumped();

private:
    int m_iNl80211id;
    bool m_bRegistered, _wiphyDumped;
    uint8_t _initiator, _type;
    ::std::string _country;
    std::vector <cWifiRadio*> _WifiRadios;

    cGenNetLink();
    int iSetUpEventHandler();
    int iGetMultiCastGroupId (const std::string family, const std::string group);

    friend class GenericSingleton<cGenNetLink>;
    DECLARE_CLASS_LOGGER();
};

	}
}

#endif //_GENERIC_NETLINK_H

/** @} */
