/**
 * @file CountryChangeNotifier.h
 * @author RBEI/ECO3 Usman Sheik
 * @copyright (c) 2018 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */
#ifndef _COUNTRY_CHANGE_NOTIFIER_H
#define _COUNTRY_CHANGE_NOTIFIER_H

#include "asf/core/Logger.h"
#include "RegulatoryMethod.h"

namespace org {
	namespace bosch {

class cCountryChangeNotifier {

public:

	cCountryChangeNotifier() : _serviceAvailability(false), _saupdate(false) { }
	virtual ~cCountryChangeNotifier() { }

	virtual int registerCountryChangeNotification(cCountryChangeUpdate *listener) {

		::asf::core::Logger oLogger("wifi_business_logic/Regulation",
				::asf::core::Logger::Debug);

		if (!listener)
			return -EINVAL;

		oLogger.info ("Registering the Country Change Observer: %p", __LINE__, __FILE__, listener);
		if (::std::find(_countryChangeObservers.begin(), _countryChangeObservers.end(),
				listener) != _countryChangeObservers.end())
			return -EALREADY;

		_countryChangeObservers.push_back (listener);
		return 0;
	}

	virtual int unRegisterCountryChangeNotification(cCountryChangeUpdate *listener) {
		::asf::core::Logger oLogger("wifi_business_logic/Regulation",
				::asf::core::Logger::Debug);
		std::vector< cCountryChangeUpdate *>::iterator it;

		if (!listener)
			return -EINVAL;

		oLogger.info ("UnRegistering the country change Observer: %p", __LINE__, __FILE__, listener);

		it = ::std::find(_countryChangeObservers.begin(), _countryChangeObservers.end(), listener);
		if (it == _countryChangeObservers.end())
			return -ENOENT;
		else _countryChangeObservers.erase(it);

		return 0;
	}

	virtual void updateServiceAvailability(bool update) {
		::asf::core::Logger oLogger("wifi_business_logic/Regulation",
				::asf::core::Logger::Debug);
		oLogger.info ("%p Current service availability update Status: %s Changed status: %s", __LINE__, __FILE__,
				this, _saupdate ? "Update" : "Dont_Update", update ? "Update"
						: "Dont_Update");
		_saupdate = update;
	}

protected:
	::std::string _country;
	bool _serviceAvailability, _saupdate;
	::std::vector< cCountryChangeUpdate* > _countryChangeObservers;
	void updateCountryChange(const ::std::string &country) {
		std::vector< cCountryChangeUpdate *>::iterator it;
		for (it = _countryChangeObservers.begin(); it < _countryChangeObservers.end(); it++)
			(*it)->countryChangeUpdate(country);
	}
	void setServiceAvailability(bool availability) {

		::asf::core::Logger oLogger("wifi_business_logic/Regulation",
				::asf::core::Logger::Debug);

		oLogger.info ("Current Status: %s, Changed status: %s, status could be updated: %s", __LINE__, __FILE__,
				_serviceAvailability ?
						"Available" : "NotAvailable", availability ? "Available" : "NotAvailable",
								  _saupdate ? "update" : "Dont_update");

		if (_serviceAvailability && !availability) {
			_serviceAvailability = false;
			if (_saupdate)
				updateCountryChangeAvailability(_serviceAvailability);
		}
		else if (!_serviceAvailability && availability) {
			_serviceAvailability = true;
			if (_saupdate)
				updateCountryChangeAvailability(_serviceAvailability);
		}
	}

private:

	void updateCountryChangeAvailability(bool availability) {
		std::vector< cCountryChangeUpdate *>::iterator it;
		for (it = _countryChangeObservers.begin(); it < _countryChangeObservers.end(); it++)
			(*it)->countryChangeAvailability(availability);
	}
};

	}
}

#endif //_COUNTRY_CHANGE_NOTIFIER_H

/** @} */
