/**
 * @file WBLPriorityManager.cpp
 * @author RBEI/ECO32 Karthikeyan Madeswaran
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#include <vector>

#include "WBLPriorityManager.h"
#include "WBLASFComponent.h"


namespace org
{
namespace bosch
{

#define DEFAULT_CONFLICT_TIMER 0

DEFINE_CLASS_LOGGER_AND_LEVEL("wifi_business_logic/PriorityMgr", WBLPriorityManager, Info);

WBLPriorityManager::WBLPriorityManager():
      _timer(DEFAULT_CONFLICT_TIMER)
{
   LOG_INFO("WBLPriorityManager:Constructor");

}

WBLPriorityManager::~WBLPriorityManager()
{

}

void WBLPriorityManager::updateAllInterfaces()
{
   LOG_INFO("WBLPriorityManager:updateAllInterfaces");

   PriorityList list;
   uint timer = 0;
   DBManagerFactory *poDBFactory = DBManagerFactory::getInstance();
   IDBManager* IDBManager = (poDBFactory) ? (poDBFactory->getDBManagerIf()) : (nullptr);
   if (IDBManager)
   {
      if (!IDBManager->readPMFromDB(list, timer))
      {
         LOG_INFO("WBLPriorityManager:updateAllInterfaces Failed to Read");
         loadDefaultTimerValue(timer);
      }
      if(list.empty())
      {
         LOG_INFO("WBLPriorityManager:updateAllInterfaces Empty Priority List. Load Default VAlues");
         loadDefaultModeValues(list);
      }
   }
   LOG_INFO("WBLPriorityManager:onWBLStartup Modes Size: %d", list.size());

   WBLServiceFactory* poServiceFactory =  WBLServiceFactory::getInstance();

   IConflictManagementService* conflictServiceIf =
         (poServiceFactory) ? (poServiceFactory->getConflictManagementServiceIf()) : (nullptr);

   if (conflictServiceIf)
   {
      conflictServiceIf->onWifiPriorityList(list);
      conflictServiceIf->onChangeinConfigurationTimer(static_cast<uint16>(timer));
   }
   _wifiPriorityList = list;
   _timer = timer;
}

void WBLPriorityManager::onPMChangeinModes(PriorityList &list)
{
   LOG_INFO("WBLPriorityManager:onPMChangeinModes");
   if(_wifiPriorityList != list)
   {
      _wifiPriorityList = list;
       PriorityList::const_iterator itr;
       DBManagerFactory *poDBFactory = DBManagerFactory::getInstance();
       IDBManager* IDBManager = (poDBFactory) ? (poDBFactory->getDBManagerIf()) : (nullptr);
       if (IDBManager)
       {
          LOG_DEBUG("Update PM value in DB");
          if (!IDBManager->writeModesToDB(list))
          {
             LOG_INFO("Write Failed So Load Default Values");
             loadDefaultModeValues(list);
          }
       }
       WBLServiceFactory* poServiceFactory =  WBLServiceFactory::getInstance();
       IConflictManagementService* conflictServiceIf =
             (poServiceFactory) ? (poServiceFactory->getConflictManagementServiceIf()) : (nullptr);
       if (conflictServiceIf)
       {
          conflictServiceIf->onWifiPriorityList(_wifiPriorityList);
       }
   }
}

void WBLPriorityManager::onPMChangeinTimer(uint &timer)
{
   LOG_INFO("WBLPriorityManager:onPMChangeinTimer");
   if(_timer != timer)
   {
      _timer = timer;
      DBManagerFactory *poDBFactory = DBManagerFactory::getInstance();
      IDBManager* IDBManager = (poDBFactory) ? (poDBFactory->getDBManagerIf()) : (nullptr);
      if (IDBManager)
      {
         LOG_DEBUG("Update PM value in DB");
         if (!IDBManager->writeTimerToDB(timer))
         {
            LOG_INFO("Write Failed So Load Default Values");
            loadDefaultTimerValue(timer);
         }
      }
      WBLServiceFactory* poServiceFactory =  WBLServiceFactory::getInstance();
      IConflictManagementService* conflictServiceIf =
            (poServiceFactory) ? (poServiceFactory->getConflictManagementServiceIf()) : (nullptr);
      if (conflictServiceIf)
      {
         conflictServiceIf->onChangeinConfigurationTimer(static_cast<uint16>(_timer));
      }
   }
}

void WBLPriorityManager::loadDefaultModeValues(PriorityList &list)
{
   LOG_INFO("WBLPriorityManager:loadDefaultModeValues");
   PriorityList::iterator it;
   list.clear();
   list.push_back((WifiMode) wblWifiMode.convertString2Enum("AP"));
   list.push_back((WifiMode) wblWifiMode.convertString2Enum("STA"));
   list.push_back((WifiMode) wblWifiMode.convertString2Enum("P2P"));
}

void WBLPriorityManager::loadDefaultTimerValue(uint &timer)
{
   LOG_INFO("WBLPriorityManager:loadDefaultTimerValue");
   timer = DEFAULT_CONFLICT_TIMER;
}

} // namespace bosch
} // namespace org

/** @} */
