/**
 * @file WBLPriorityManagerFactory.h
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _PRIORITY_MANAGER_FACTORY_H
#define _PRIORITY_MANAGER_FACTORY_H

#include "WBLMessageTypes.h"
#include "GenericSingleton.h"
#include "WBLPriorityManager.h"
#include "IWBLPriorityManager.h"

namespace org
{
namespace bosch
{

class WBLPriorityManagerFactory final: public GenericSingleton<WBLPriorityManagerFactory>
{

public:
   WBLPriorityManagerFactory(const WBLPriorityManagerFactory& ref);
   WBLPriorityManagerFactory& operator=(const WBLPriorityManagerFactory& ref);
   virtual ~WBLPriorityManagerFactory()
   {
      RELEASE_MEM(_poWBLPriorityManagerIf);
   }

   IWBLPriorityManager* getWBLPriorityManagerIf()
   {
      return _poWBLPriorityManagerIf;
   }

private:
   friend class GenericSingleton<WBLPriorityManagerFactory> ;
   IWBLPriorityManager* _poWBLPriorityManagerIf;
   WBLPriorityManagerFactory() :
         _poWBLPriorityManagerIf(nullptr)
   {
      _poWBLPriorityManagerIf = new WBLPriorityManager();
      //WBL_ASSERT(_poPMManagerIf);
   }

};

} // namespace bosch
} // namespace org

#endif //_PRIORITY_MANAGER_FACTORY_H
/** @} */
