/**
 * @file IEEE80211STAClientIf.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */
#ifndef _IEEE_80211_STA_CLIENT_IF_H
#define _IEEE_80211_STA_CLIENT_IF_H

#include "IEEE80211Client.h"
#include "STAModeClient_Types.h"

namespace org 
{
namespace bosch 
{

//Forward declaration

class IEEE80211STAConnectionStatusNotifier;

class IEEE80211STAClientIf : public IEEE80211Client
{
public:

   IEEE80211STAClientIf()
   {
   }

   virtual ~IEEE80211STAClientIf()
   {
   }

   virtual void getTechnologies(TechnologyList& list) = 0;
   virtual int subscribeIEEE80211STAConnectionStatus(IEEE80211STAConnectionStatusNotifier *listener) = 0;
   virtual int unSubscribeIEEE80211STAConnectionStatus(IEEE80211STAConnectionStatusNotifier *listener) = 0;
   virtual int createConnManServiceProxy(const ::std::string &objpath) = 0;
   virtual int destroyConnManServiceProxy(const ::std::string &objpath) = 0;
};

} // namespace bosch
} // namespace org

#endif //_IEEE_80211_STA_CLIENT_IF_H

/** @} */
