/**
 * @file IEEE80211APClientIf.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */
 
#ifndef _IEEE_80211_AP_CLIENT_IF_H
#define _IEEE_80211_AP_CLIENT_IF_H

#include <string>

#include "IEEE80211Client.h"
#include "APModeClient_Types.h"
#include "RegulatoryChannelAvailability.h"

namespace org
{
namespace bosch
{

class cWifiAPPowerStateNotifier;

class IEEE80211APClientIf: public IEEE80211Client, public cRegulatoryChannel
{
public:

   IEEE80211APClientIf() : cRegulatoryChannel(REGULATORY_CHANNEL_WIFI_AP_DIRECT_MANAGER)
   {
   }

   virtual ~IEEE80211APClientIf()
   {
   }

   virtual void getAccessPoints(AccessPointList& apList) const = 0;
   virtual void getAssociatedStations(AssociatedStationList& asList) const = 0;
   virtual bool setSSID(const ::std::string& objPath, const ::std::vector< uint8 >& ssid, bool utf_ssid) = 0;
   virtual bool setPassphrase(const ::std::string& objPath, const ::std::string& passphrase) = 0;
   virtual bool setPassphrase(const ::std::string& objPath, WBLAPType apType,WBLActionType actionType) = 0;
   virtual bool setHidden(const ::std::string& objPath, bool hidden) = 0;
   virtual bool setSecurity(const ::std::string& objPath, const ::std::string& security) = 0;
   virtual bool deAuthenticateStation(const ::std::string& objPath, const ::std::string& macAddress) = 0;
   virtual bool setOperatingChannels(const ::std::string& objPath, const ::std::vector< uint16 >& channels) = 0;
   virtual bool restoreAPSettings(const ::std::string& objPath) = 0;
   virtual void setAPType(const ::std::string& objPath,WBLAPType apType) = 0;
   virtual bool setTethering(const ::std::string& objPath, bool tethering) = 0;
   virtual bool setMaxStationsAllowed(const ::std::string& objPath, uint16 noOfStations) = 0;
   virtual bool updateRegisterVendorService(const ::std::string& objPath) = 0;
   virtual bool updateUnregisterVendorService(const ::std::string& objPath) = 0;
   virtual bool setNetworkType(const ::std::string& objPath, WifiAccessNetworkType& networkType) = 0;
};

} // namespace bosch
} // namespace org

#endif //_IEEE_80211_AP_CLIENT_IF_H

/** @} */
