/**
 * @file STAModeClient_Types.cpp
 * @author RBEI/ECO32 Jiji Anna Jacob
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */

#include "STAModeClient_Types.h"

namespace org
{
namespace bosch
{

TechnologyProperty::TechnologyProperty():
   isPowered(false),
   powerState(WIFI_STATE_UNKNOWN),
   isConnected(false),
   name(" "),
   type(" "),
   frequency(255),
   currChannel(255),
   connHealth(100)
{
}

TechnologyProperty::TechnologyProperty(const TechnologyProperty &ref):
   isPowered(ref.isPowered),
   powerState(ref.powerState),
   isConnected(ref.isConnected),
   name(ref.name),
   type(ref.type),
   frequency(ref.frequency),
   currChannel(ref.currChannel),
   connHealth(ref.connHealth)
{
}

TechnologyProperty::~TechnologyProperty()
{
}

bool TechnologyProperty::operator==(const TechnologyProperty &ref)
{
   return ((isPowered == ref.isPowered) && (isConnected == ref.isConnected) && (name == ref.name) && (type == ref.type)
         && (frequency == ref.frequency) && (currChannel == ref.currChannel)&&(connHealth == ref.connHealth));
}

TechnologyProperty& TechnologyProperty::operator=(const TechnologyProperty &ref)
{
   if (this == &ref)
      return *this;

   isPowered = ref.isPowered;
   powerState = ref.powerState;
   isConnected = ref.isConnected;
   name = ref.name;
   type = ref.type;
   frequency = ref.frequency;
   currChannel = ref.currChannel;
   connHealth =  ref.connHealth;

   return *this;
}

TechnologyItem::TechnologyItem()
{
}

TechnologyItem::TechnologyItem(const TechnologyItem &ref):
   objPath(ref.objPath),
   property(ref.property)
{
}

TechnologyItem::~TechnologyItem()
{
}

bool TechnologyItem::operator==(const TechnologyItem &ref)
{
   return ((objPath == ref.objPath) && (property == ref.property));
}

TechnologyItem& TechnologyItem::operator=(const TechnologyItem &ref)
{
   if (this == &ref)
      return *this;

   objPath = ref.objPath;
   property = ref.property;

   return *this;
}

} //namespace bosch
} //namespace org

/** @} */
