/**
 * @file IEEE80211ClientProperties.cpp
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#include "IEEE80211ClientProperties.h"

namespace org
{
namespace bosch
{

IEEE80211EventProperty::IEEE80211EventProperty() :
            DbusProperties(),
            _eventSTATechAdded("EVENT_STA_TECH_ADDED"),
            _eventSTATechRemoved("EVENT_STA_TECH_REMOVED"),
            _eventSTAPowered("EVENT_STA_POWERED"),
            _eventSTAConnected("EVENT_STA_CONNECTED"),
            _eventSTAName("EVENT_STA_NAME"),
            _eventSTAType("EVENT_STA_TYPE"),
            _eventSTACurrentChannel("EVENT_STA_CURR_CHANNEL"),
            _eventSTARestoreStart("EVENT_STA_RESTORE_START"),
            _eventSTARestoreComplete("EVENT_STA_RESTORE_COMPLETE"),
            _eventAPAdded("EVENT_AP_ADDED"),
            _eventAPRemoved("EVENT_AP_REMOVED"),
            _eventAPASAdded("EVENT_AP_AS_ADDED"),
            _eventAPASRemoved("EVENT_AP_AS_REMOVED"),
            _eventAPPowered("EVENT_AP_POWERED"),
            _eventAPSSID("EVENT_AP_SSID"),
            _eventAPPassphrase("EVENT_AP_PASSPHRASE"),
            _eventAPCurrentChannel("EVENT_AP_CURRENTCHANNEL"),
            _eventAPSecurity("EVENT_AP_SECURITY"),
            _eventAPVendorID("EVENT_AP_VENDORID"),
            _eventAPMacAddress("EVENT_AP_MACADDRESS"),
            _eventAPSuppChannels("EVENT_AP_SUPPCHANNELS"),
            _eventAPMaxStations("EVENT_AP_MAX_STA"),
            _eventAPHidden("EVENT_AP_HIDDEN"),
            _eventAPInterface("EVENT_AP_INTERFACE"),
            _eventAPType("EVENT_AP_TYPE"),
            _eventAPIPv4ConfigurationList("EVENT_AP_IPV4CONFIGURATION"),
            _eventAPTethering("EVENT_AP_TETHERING"),
            _eventAPHealth("EVENT_AP_HEALTH"),
            _eventASMacAddress("EVENT_AS_MACADDRESS"),
            _eventASAPPath("EVENT_AS_APPATH"),
            _eventASInterface("EVENT_AS_INTERFACE"),
            _eventASIPAddress("EVENT_AS_IPADDRESS"),
            _eventASHostname("EVENT_AS_HOSTNAME"),
            _eventAPSetOpChannel("EVENT_AP_SETOPERATINGCHANNEL"),
            _eventAPDeauthStation("EVENT_AP_DEAUTHSTATION"),
            _eventAPRestoreStart("EVENT_AP_RESTORE_START"),
            _eventAPRestoreComplete("EVENT_AP_RESTORE_COMPLETE"),
            _eventUnknown("EVENT_UNKNOWN")
{
   _string2EnumList[_eventSTATechAdded] = (int) IEEE80211_MSG_STA_MODE_TECHNOLOGYADDED_IND;
   _string2EnumList[_eventSTATechRemoved] = (int) IEEE80211_MSG_STA_MODE_TECHNOLOGYREMOVED_IND;
   _string2EnumList[_eventSTAPowered] = (int) IEEE80211_MSG_STA_MODE_POWERED_IND;
   _string2EnumList[_eventSTAPowereState] = (int) IEEE80211_MSG_STA_MODE_POWERSTATE_IND;
   _string2EnumList[_eventSTAConnected] = (int) IEEE80211_MSG_STA_MODE_CONNECTED_IND;
   _string2EnumList[_eventSTAName] = (int) IEEE80211_MSG_STA_MODE_NAME_IND;
   _string2EnumList[_eventSTAType] = (int) IEEE80211_MSG_STA_MODE_TYPE_IND;
   _string2EnumList[_eventSTACurrentChannel] = (int) IEEE80211_MSG_STA_MODE_CURRCHANNEL_IND;
   _string2EnumList[_eventSTARestoreStart] = (int) IEEE80211_MSG_STA_MODE_RESTORE_START;
   _string2EnumList[_eventSTARestoreComplete] = (int) IEEE80211_MSG_STA_MODE_RESTORE_COMPLETE;
   _string2EnumList[_eventAPAdded] = (int) IEEE80211_MSG_AP_MODE_APADDED_IND;
   _string2EnumList[_eventAPRemoved] = (int) IEEE80211_MSG_AP_MODE_APREMOVED_IND;
   _string2EnumList[_eventAPASAdded] = (int) IEEE80211_MSG_AP_MODE_ASADDED_IND;
   _string2EnumList[_eventAPASRemoved] = (int) IEEE80211_MSG_AP_MODE_ASREMOVED_IND;
   _string2EnumList[_eventAPPowered] = (int) IEEE80211_MSG_AP_MODE_AP_POWERED_IND;
   _string2EnumList[_eventAPPowerState] = (int) IEEE80211_MSG_AP_MODE_AP_POWERSTATE_IND;
   _string2EnumList[_eventAPPowerFailure] = (int) IEEE80211_MSG_AP_MODE_AP_POWERFAILURE_IND;
   _string2EnumList[_eventAPSSID] = (int) IEEE80211_MSG_AP_MODE_AP_SSID_IND;
   _string2EnumList[_eventAPPassphrase] = (int) IEEE80211_MSG_AP_MODE_AP_PASSPHRASE_IND;
   _string2EnumList[_eventAPCurrentChannel] = (int) IEEE80211_MSG_AP_MODE_AP_CURRENTCHANNEL_IND;
   _string2EnumList[_eventAPSecurity] = (int) IEEE80211_MSG_AP_MODE_AP_SECURITY_IND;
   _string2EnumList[_eventAPVendorID] = (int) IEEE80211_MSG_AP_MODE_AP_VENDOR_IES_IND;
   _string2EnumList[_eventAPMacAddress] = (int) IEEE80211_MSG_AP_MODE_AP_MACADDRESS_IND;
   _string2EnumList[_eventAPSuppChannels] = (int) IEEE80211_MSG_AP_MODE_AP_SUPPCHANNELS_IND;
   _string2EnumList[_eventAPMaxStations] = (int) IEEE80211_MSG_AP_MODE_AP_MAXSTA_IND;
   _string2EnumList[_eventAPHidden] = (int) IEEE80211_MSG_AP_MODE_AP_HIDDEN_IND;
   _string2EnumList[_eventAPInterface] = (int) IEEE80211_MSG_AP_MODE_AP_INTERFACE_IND;
   _string2EnumList[_eventAPType] = (int) IEEE80211_MSG_AP_MODE_AP_TYPE_IND;
   _string2EnumList[_eventAPIPv4ConfigurationList] = (int) IEEE80211_MSG_AP_MODE_AP_IPV4_CONFIGURATION_IND;
   _string2EnumList[_eventAPTethering] = (int) IEEE80211_MSG_AP_MODE_AP_TETHERING_IND;
   _string2EnumList[_eventAPHealth] = (int) IEEE80211_MSG_AP_MODE_AP_HEALTH_IND;
   _string2EnumList[_eventASMacAddress] = (int) IEEE80211_MSG_AP_MODE_AS_MACADDRESS_IND;
   _string2EnumList[_eventASAPPath] = (int) IEEE80211_MSG_AP_MODE_AS_APPATH_IND;
   _string2EnumList[_eventASInterface] = (int) IEEE80211_MSG_AP_MODE_AS_INTERFACE_IND;
   _string2EnumList[_eventASIPAddress] = (int) IEEE80211_MSG_AP_MODE_AS_IPADDRESS_IND;
   _string2EnumList[_eventASHostname] = (int) IEEE80211_MSG_AP_MODE_AS_HOSTNAME_IND;
   _string2EnumList[_eventAPSetOpChannel] = (int) IEEE80211_MSG_AP_MODE_AP_SETOPERATINGCHANNEL;
   _string2EnumList[_eventAPDeauthStation] = (int) IEEE80211_MSG_AP_MODE_AP_DEAUTHENTICATESTATION;
   _string2EnumList[_eventAPRestoreStart] = (int) IEEE80211_MSG_AP_MODE_RESTORE_START;
   _string2EnumList[_eventAPRestoreComplete] = (int) IEEE80211_MSG_AP_MODE_RESTORE_COMPLETE;
   _string2EnumList[_eventUnknown] = (int) IEEE80211_MSG_UNKNOWN;

   _enum2StringList[(int) IEEE80211_MSG_STA_MODE_TECHNOLOGYADDED_IND] = &_eventSTATechAdded;
   _enum2StringList[(int) IEEE80211_MSG_STA_MODE_TECHNOLOGYREMOVED_IND] = &_eventSTATechRemoved;
   _enum2StringList[(int) IEEE80211_MSG_STA_MODE_POWERED_IND] = &_eventSTAPowered;
   _enum2StringList[(int) IEEE80211_MSG_STA_MODE_POWERSTATE_IND] = &_eventSTAPowereState;
   _enum2StringList[(int) IEEE80211_MSG_STA_MODE_CONNECTED_IND] = &_eventSTAConnected;
   _enum2StringList[(int) IEEE80211_MSG_STA_MODE_NAME_IND] = &_eventSTAName;
   _enum2StringList[(int) IEEE80211_MSG_STA_MODE_TYPE_IND] = &_eventSTAType;
   _enum2StringList[(int) IEEE80211_MSG_STA_MODE_CURRCHANNEL_IND] = &_eventSTACurrentChannel;
   _enum2StringList[(int) IEEE80211_MSG_STA_MODE_RESTORE_START] = &_eventSTARestoreStart;
   _enum2StringList[(int) IEEE80211_MSG_STA_MODE_RESTORE_COMPLETE] = &_eventSTARestoreComplete;
   _enum2StringList[(int) IEEE80211_MSG_AP_MODE_APADDED_IND] = &_eventAPAdded;
   _enum2StringList[(int) IEEE80211_MSG_AP_MODE_APREMOVED_IND] = &_eventAPRemoved;
   _enum2StringList[(int) IEEE80211_MSG_AP_MODE_ASADDED_IND] = &_eventAPASAdded;
   _enum2StringList[(int) IEEE80211_MSG_AP_MODE_ASREMOVED_IND] = &_eventAPASRemoved;
   _enum2StringList[(int) IEEE80211_MSG_AP_MODE_AP_POWERED_IND] = &_eventAPPowered;
   _enum2StringList[(int) IEEE80211_MSG_AP_MODE_AP_POWERSTATE_IND] = &_eventAPPowerState;
   _enum2StringList[(int) IEEE80211_MSG_AP_MODE_AP_POWERFAILURE_IND] = &_eventAPPowerFailure;
   _enum2StringList[(int) IEEE80211_MSG_AP_MODE_AP_SSID_IND] = &_eventAPSSID;
   _enum2StringList[(int) IEEE80211_MSG_AP_MODE_AP_PASSPHRASE_IND] = &_eventAPPassphrase;
   _enum2StringList[(int) IEEE80211_MSG_AP_MODE_AP_CURRENTCHANNEL_IND] = &_eventAPCurrentChannel;
   _enum2StringList[(int) IEEE80211_MSG_AP_MODE_AP_SECURITY_IND] = &_eventAPSecurity;
   _enum2StringList[(int) IEEE80211_MSG_AP_MODE_AP_VENDOR_IES_IND] = &_eventAPVendorID;
   _enum2StringList[(int) IEEE80211_MSG_AP_MODE_AP_MACADDRESS_IND] = &_eventAPMacAddress;
   _enum2StringList[(int) IEEE80211_MSG_AP_MODE_AP_SUPPCHANNELS_IND] = &_eventAPSuppChannels;
   _enum2StringList[(int) IEEE80211_MSG_AP_MODE_AP_MAXSTA_IND] = &_eventAPMaxStations;
   _enum2StringList[(int) IEEE80211_MSG_AP_MODE_AP_HIDDEN_IND] = &_eventAPHidden;
   _enum2StringList[(int) IEEE80211_MSG_AP_MODE_AP_INTERFACE_IND] = &_eventAPInterface;
   _enum2StringList[(int) IEEE80211_MSG_AP_MODE_AP_TYPE_IND] = &_eventAPType;
   _enum2StringList[(int) IEEE80211_MSG_AP_MODE_AP_IPV4_CONFIGURATION_IND] = &_eventAPIPv4ConfigurationList;
   _enum2StringList[(int) IEEE80211_MSG_AP_MODE_AP_TETHERING_IND] = &_eventAPTethering;
   _enum2StringList[(int) IEEE80211_MSG_AP_MODE_AP_HEALTH_IND] = &_eventAPHealth;
   _enum2StringList[(int) IEEE80211_MSG_AP_MODE_AS_MACADDRESS_IND] = &_eventASMacAddress;
   _enum2StringList[(int) IEEE80211_MSG_AP_MODE_AS_APPATH_IND] = &_eventASAPPath;
   _enum2StringList[(int) IEEE80211_MSG_AP_MODE_AS_INTERFACE_IND] = &_eventASInterface;
   _enum2StringList[(int) IEEE80211_MSG_AP_MODE_AS_IPADDRESS_IND] = &_eventASIPAddress;
   _enum2StringList[(int) IEEE80211_MSG_AP_MODE_AS_HOSTNAME_IND] = &_eventASHostname;
   _enum2StringList[(int) IEEE80211_MSG_AP_MODE_AP_SETOPERATINGCHANNEL] = &_eventAPSetOpChannel;
   _enum2StringList[(int) IEEE80211_MSG_AP_MODE_AP_DEAUTHENTICATESTATION] = &_eventAPDeauthStation;
   _enum2StringList[(int) IEEE80211_MSG_AP_MODE_RESTORE_START] = &_eventAPRestoreStart;
   _enum2StringList[(int) IEEE80211_MSG_AP_MODE_RESTORE_COMPLETE] = &_eventAPRestoreComplete;
   _enum2StringList[(int) IEEE80211_MSG_UNKNOWN] = &_eventUnknown;
}

IEEE80211EventProperty::~IEEE80211EventProperty()
{
}

IEEE80211EventID IEEE80211EventProperty::getEvent2Enum(const ::std::string& value) const
{
   return (IEEE80211EventID) convertString2Enum(value);
}

const ::std::string& IEEE80211EventProperty::getEvent2String(const IEEE80211EventID value) const
{
   return convertEnum2String((const int) value);
}

IEEE80211ErrorProperty::IEEE80211ErrorProperty() :
            DbusProperties(),
            _errorNone("ERROR_NONE"),
            _errorInvalidArgs("ERROR_INVALID_ARGS"),
            _errorInvalidSta("ERROR_INVALID_STA"),
            _errorInvalidChannel("ERROR_INVALID_CHANNEL"),
            _errorInvalidLength("ERROR_INVALID_LENGTH"),
            _errorUnknown("ERROR_UNKNOWN")
{
   _string2EnumList[_errorNone] = (int) IEEE80211_ERROR_NONE;
   _string2EnumList[_errorInvalidArgs] = (int) IEEE80211_ERROR_INVALID_ARGS;
   _string2EnumList[_errorInvalidSta] = (int) IEEE80211_ERROR_INVALID_STA;
   _string2EnumList[_errorInvalidChannel] = (int) IEEE80211_ERROR_INVALID_CHANNEL;
   _string2EnumList[_errorInvalidLength] = (int) IEEE80211_ERROR_INVALID_LENGTH;
   _string2EnumList[_errorUnknown] = (int) IEEE80211_ERROR_UNKNOWN;

   _enum2StringList[(int) IEEE80211_ERROR_NONE] = &_errorNone;
   _enum2StringList[(int) IEEE80211_ERROR_INVALID_ARGS] = &_errorInvalidArgs;
   _enum2StringList[(int) IEEE80211_ERROR_INVALID_STA] = &_errorInvalidSta;
   _enum2StringList[(int) IEEE80211_ERROR_INVALID_CHANNEL] = &_errorInvalidChannel;
   _enum2StringList[(int) IEEE80211_ERROR_INVALID_LENGTH] = &_errorInvalidLength;
   _enum2StringList[(int) IEEE80211_ERROR_UNKNOWN] = &_errorUnknown;
}

IEEE80211ErrorProperty::~IEEE80211ErrorProperty()
{
}

IEEE80211ErrorCode IEEE80211ErrorProperty::getState2Enum(const ::std::string& value) const
{
   return (IEEE80211ErrorCode) convertString2Enum(value);
}

const ::std::string& IEEE80211ErrorProperty::getState2String(const IEEE80211ErrorCode value) const
{
   return convertEnum2String((const int) value);
}


} //namespace bosch
} //namespace org

/** @} */
