/**
 * @file APModeClient_Types.cpp
 * @author RBEI/ECO32 Jiji Anna Jacob
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */

#include "APModeClient_Types.h"

namespace org
{
namespace bosch
{

AssociatedStationProperty::AssociatedStationProperty():
   macAddress(""),
   apPath(""),
   interface(""),
   ipAddress(""),
   hostName("")
{
}

AssociatedStationProperty::AssociatedStationProperty(const AssociatedStationProperty &ref):
   macAddress(ref.macAddress),
   apPath(ref.apPath),
   interface(ref.interface),
   ipAddress(ref.ipAddress),
   hostName(ref.hostName)
{
}

AssociatedStationProperty::~AssociatedStationProperty()
{
}

bool AssociatedStationProperty::operator==(const AssociatedStationProperty &ref)
{
   return ((!ref.macAddress.empty() && macAddress == ref.macAddress) &&
         (!ref.apPath.empty() && apPath == ref.apPath) &&
         (!ref.interface.empty() && interface == ref.interface) &&
         (!ref.ipAddress.empty() && ipAddress == ref.ipAddress) &&
         (!ref.hostName.empty() && hostName == ref.hostName) );
}

AssociatedStationProperty& AssociatedStationProperty::operator=(const AssociatedStationProperty &ref)
{
   if (this == &ref)
      return *this;

   macAddress = ref.macAddress;
   apPath = ref.apPath;
   interface = ref.interface;
   ipAddress = ref.ipAddress;
   hostName = ref.hostName;

   return *this;
}

bool AssociatedStationProperty::isEmpty()
{
   return macAddress.empty() &&  apPath.empty() && interface.empty() && ipAddress.empty() && hostName.empty();
}

AssociatedStationItem::AssociatedStationItem()
{
   updated = false;
}

AssociatedStationItem::AssociatedStationItem(const AssociatedStationItem &ref):
   objPath(ref.objPath),
   updated (ref.updated),
   property(ref.property)
{
}

AssociatedStationItem::~AssociatedStationItem()
{
}

bool AssociatedStationItem::operator==(const AssociatedStationItem &ref)
{
   return ((objPath == ref.objPath) && (property == ref.property));
}

AssociatedStationItem& AssociatedStationItem::operator=(const AssociatedStationItem &ref)
{
   if (this == &ref)
      return *this;

   objPath = ref.objPath;
   property = ref.property;
   updated = ref.updated;

   return *this;
}

AccessPointProperty::AccessPointProperty():
    macAddress(""),
    interface(""),
    powerState(WIFI_STATE_UNKNOWN),
    powerFailure(WIFI_POWER_FAILURE_REASON_UNKNOWN),
    isPowered(false),
    security(WBL_SECURITY_UNKNOWN),
    passphrase(""),
    currChannel(0),
    maxStations(0),
    isHidden(false),
    type(WBL_AP_TYPE_UNKNOWN),
    isTethering(false),
    isVendorElementRegistered(false),
    connHealth(100),
    wifiAccessNetworkType(WIFI_PRIVATE_NETWORK)
{
}

AccessPointProperty::AccessPointProperty(const AccessPointProperty &ref):
   macAddress(ref.macAddress),
   ssid(ref.ssid),
   interface(ref.interface),
   powerState(ref.powerState),
   powerFailure(ref.powerFailure),
   isPowered(ref.isPowered),
   security(ref.security),
   passphrase(ref.passphrase),
   chanList(ref.chanList),
   currChannel(ref.currChannel),
   maxStations(ref.maxStations),
   vendorIEs(ref.vendorIEs),
   isHidden(ref.isHidden),
   asList(ref.asList),
   type(ref.type),
   ipv4ConfigurationList(ref.ipv4ConfigurationList),
   isTethering(ref.isTethering),
   isVendorElementRegistered(ref.isVendorElementRegistered),
   connHealth(ref.connHealth),
   wifiAccessNetworkType(ref.wifiAccessNetworkType)
{
}

AccessPointProperty::~AccessPointProperty()
{
}

bool AccessPointProperty::operator==(const AccessPointProperty &ref)
{
   return (
         (macAddress == ref.macAddress)&& (interface == ref.interface) && (powerState == ref.powerState) &&
         (isPowered == ref.isPowered) && (security == ref.security) && (passphrase == ref.passphrase) &&
         (currChannel == ref.currChannel) && (maxStations == ref.maxStations) && (isHidden == ref.isHidden) &&
         (vendorIEs == ref.vendorIEs) && (ssid == ref.ssid) && (powerFailure == ref.powerFailure) &&
         (isTethering == ref.isTethering) && /*(isVendorElementRegistered == ref.isVendorElementRegistered) &&*/
         (type == ref.type) &&(wifiAccessNetworkType == ref.wifiAccessNetworkType) &&
         (connHealth == ref.connHealth) && (true == std::equal(ref.chanList.begin(), ref.chanList.end(), chanList.begin()))&&
         (true == std::equal(chanList.begin(), chanList.end(), ref.chanList.begin()))&&
         (true == std::equal(asList.begin(), asList.end(), ref.asList.begin()))&&
         (true == std::equal(ipv4ConfigurationList.begin(), ipv4ConfigurationList.end(), ref.ipv4ConfigurationList.begin())));
}

AccessPointProperty& AccessPointProperty::operator=(const AccessPointProperty &ref)
{
   if (this == &ref)
      return *this;

   macAddress = ref.macAddress;
   ssid = ref.ssid;
   interface = ref.interface;
   powerState = ref.powerState;
   isPowered = ref.isPowered;
   powerFailure = ref.powerFailure;
   security = ref.security;
   passphrase = ref.passphrase;
   chanList = ref.chanList;
   currChannel = ref.currChannel;
   maxStations = ref.maxStations;
   vendorIEs = ref.vendorIEs;
   isHidden = ref.isHidden;
   asList = ref.asList;
   type = ref.type;
   ipv4ConfigurationList = ref.ipv4ConfigurationList;
   isTethering = ref.isTethering;
   isVendorElementRegistered = ref.isVendorElementRegistered;
   connHealth = ref.connHealth;
   wifiAccessNetworkType =  ref.wifiAccessNetworkType;
   return *this;
}

AccessPointItem::AccessPointItem()
{
}

AccessPointItem::AccessPointItem(const AccessPointItem &ref):
   objPath(ref.objPath),
   property(ref.property)
{
}

AccessPointItem::~AccessPointItem()
{
}

bool AccessPointItem::operator==(const AccessPointItem &ref)
{
   return ((objPath == ref.objPath) && (property == ref.property));
}
 
AccessPointItem& AccessPointItem::operator=(const AccessPointItem &ref)
{
   if (this == &ref)
      return *this;

   objPath = ref.objPath;
   property = ref.property;

   return *this;
}

IPv4Configuration::IPv4Configuration()
{
   leasetime = 0;
}

IPv4Configuration::IPv4Configuration(const IPv4Configuration &ref):
   router(ref.router),
   startAddress(ref.startAddress),
   endAddress(ref.endAddress),
   netMask(ref.netMask),
   network(ref.network),
   broadcast(ref.broadcast),
   leasetime(ref.leasetime)
{
}

IPv4Configuration::~IPv4Configuration()
{
}

bool IPv4Configuration::operator==(const IPv4Configuration &ref)
{
   return ((!ref.router.empty() && router== ref.router) && (!ref.netMask.empty() && netMask == ref.netMask));
}

IPv4Configuration& IPv4Configuration::operator=(const IPv4Configuration &ref)
{
   if (this == &ref)
      return *this;

   router = ref.router;
   startAddress = ref.startAddress;
   endAddress = ref.endAddress;
   netMask = ref.netMask;
   network = ref.network;
   broadcast = ref.broadcast;
   leasetime = ref.leasetime;

   return *this;
}

bool IPv4Configuration::isEmpty()
{
   return (router.empty() && netMask.empty() /*&&
         startAddress.empty() && endAddress.empty() && network.empty() &&
         broadcast.empty() && leasetime.empty()*/);
}

SPITechnologies::SPITechnologies()
{
    isCPWSupport = false;
    isAAWSupport = false;
}

SPITechnologies::SPITechnologies(const SPITechnologies &ref) :
        isCPWSupport(ref.isCPWSupport), isAAWSupport(ref.isAAWSupport)
{
}

SPITechnologies::~SPITechnologies()
{
}

bool SPITechnologies::operator==(const SPITechnologies &ref)
{
   return ((isCPWSupport == ref.isCPWSupport)&&(isAAWSupport == ref.isAAWSupport));
}

SPITechnologies& SPITechnologies::operator=(const SPITechnologies &ref)
{
   if (this == &ref)
      return *this;

   isCPWSupport = ref.isCPWSupport;
   isAAWSupport = ref.isAAWSupport;
   return *this;
}


} //namespace bosch
} //namespace org

/** @} */
