/**
 * @file IEEE80211EventNotifier.h
 * @author RBEI/ECO32 Jiji Anna Jacob
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */
 
#ifndef _IEEE_80211_NOTIFIER_H
#define _IEEE_80211_NOTIFIER_H

#include <map>

#include "asf/core/Logger.h"

#include "IEEE80211Defines.h"
#include "IEEE80211EventMsg.h"

namespace org
{
namespace bosch
{

using namespace ::asf::core;
//Forward declaration
class IEEE80211EventObserver;

class IEEE80211EventNotifier
{
 
   public:

   IEEE80211EventNotifier();
   virtual ~IEEE80211EventNotifier();

   virtual bool registerObserver(IEEE80211EventType type, IEEE80211EventObserver* observer)  final;
   virtual bool deregisterObserver(IEEE80211EventType type, IEEE80211EventObserver* observer) final;
   virtual bool notifyObservers(IEEE80211EventType type, const IEEE80211EventMsg* msg) const;

   private:

   std::map<IEEE80211EventType, IEEE80211EventObserver* > _observers;
   DECLARE_CLASS_LOGGER();
};

} // namespace bosch
} // namespace org

#endif //_IEEE_80211_NOTIFIER_H

/** @} */
