/**
 * @file IEEE80211ClientProperties.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _CLIENT_PROPERTIES_H
#define _CLIENT_PROPERTIES_H

#include <string>

#include "DbusProperties.h"
#include "IEEE80211Defines.h"

namespace org
{
namespace bosch
{

class IEEE80211EventProperty: public DbusProperties
{
   public:
      IEEE80211EventProperty();
      virtual ~IEEE80211EventProperty();

      IEEE80211EventID getEvent2Enum(const ::std::string& value) const;
      const ::std::string& getEvent2String(const IEEE80211EventID value) const;

   private:
      const ::std::string _eventSTATechAdded;
      const ::std::string _eventSTATechRemoved;
      const ::std::string _eventSTAPowered;
      const ::std::string _eventSTAPowereState;
      const ::std::string _eventSTAConnected;
      const ::std::string _eventSTAName;
      const ::std::string _eventSTAType;
      const ::std::string _eventSTACurrentChannel;
      const ::std::string _eventSTARestoreStart;
      const ::std::string _eventSTARestoreComplete;
      const ::std::string _eventAPAdded;
      const ::std::string _eventAPRemoved;
      const ::std::string _eventAPASAdded;
      const ::std::string _eventAPASRemoved;
      const ::std::string _eventAPPowered;
      const ::std::string _eventAPPowerState;
      const ::std::string _eventAPPowerFailure;
      const ::std::string _eventAPSSID;
      const ::std::string _eventAPPassphrase;
      const ::std::string _eventAPCurrentChannel;
      const ::std::string _eventAPSecurity;
      const ::std::string _eventAPVendorID;
      const ::std::string _eventAPMacAddress;
      const ::std::string _eventAPSuppChannels;
      const ::std::string _eventAPMaxStations;
      const ::std::string _eventAPHidden;
      const ::std::string _eventAPInterface;
      const ::std::string _eventAPType;
      const ::std::string _eventAPIPv4ConfigurationList;
      const ::std::string _eventAPTethering;
      const ::std::string _eventAPHealth;
      const ::std::string _eventASMacAddress;
      const ::std::string _eventASAPPath;
      const ::std::string _eventASInterface;
      const ::std::string _eventASIPAddress;
      const ::std::string _eventASHostname;
      const ::std::string _eventAPSetOpChannel;
      const ::std::string _eventAPDeauthStation;
      const ::std::string _eventAPRestoreStart;
      const ::std::string _eventAPRestoreComplete;
      const ::std::string _eventUnknown;
};

class IEEE80211ErrorProperty: public DbusProperties
{
   public:
      IEEE80211ErrorProperty();
      virtual ~IEEE80211ErrorProperty();

      IEEE80211ErrorCode getState2Enum(const ::std::string& value) const;
      const ::std::string& getState2String(const IEEE80211ErrorCode value) const;

   private:
      const ::std::string _errorNone;
      const ::std::string _errorInvalidArgs;
      const ::std::string _errorInvalidSta;
      const ::std::string _errorInvalidChannel;
      const ::std::string _errorInvalidLength;
      const ::std::string _errorUnknown;

};

static IEEE80211EventProperty ieee80211Event;
static IEEE80211ErrorProperty ieee80211Error;

#define IEEE80211_EVENT_TO_STR(IEEE80211_EVENT_ID) \
   (ieee80211Event.getEnum2StringTrace(IEEE80211_EVENT_ID).c_str())
#define IEEE80211_ERR_TO_STR(IEEE80211_ERROR_CODE) \
   (ieee80211Error.getEnum2StringTrace(IEEE80211_ERROR_CODE).c_str())

} //namespace bosch
} //namespace org

#endif //_CLIENT_PROPERTIES_H

/** @} */
