/**
 * @file IEEE80211ClientFactory.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */

#ifndef _IEEE_80211_CLIENT_FACTORY_H
#define _IEEE_80211_CLIENT_FACTORY_H

#include "WBLTypes.h"
#include "WBLDefines.h"
#include "GenericSingleton.h"
#include "IEEE80211APClient.h"
#include "IEEE80211STAClient.h"

namespace org 
{
namespace bosch 
{

class IEEE80211ClientFactory final: public GenericSingleton<IEEE80211ClientFactory>
{

public:
   IEEE80211ClientFactory(const IEEE80211ClientFactory& ref);
   IEEE80211ClientFactory& operator=(const IEEE80211ClientFactory& ref);
   ~IEEE80211ClientFactory()
   {
      RELEASE_MEM(_apClientIf);
      RELEASE_MEM(_staClientIf);
   }
   IEEE80211APClientIf* getAPClientIf()
   {
      return _apClientIf;
   }

   IEEE80211STAClientIf* getSTAClientIf()
   {
      return _staClientIf;
   }

protected:

private:
   friend class GenericSingleton<IEEE80211ClientFactory>;
   IEEE80211ClientFactory():
      _apClientIf(nullptr),
      _staClientIf(nullptr)
   {
      _apClientIf = new IEEE80211APClient;
      _staClientIf = new IEEE80211STAClient;
   }

   IEEE80211APClientIf*    _apClientIf;
   IEEE80211STAClientIf*   _staClientIf;
};

} // namespace bosch
} // namespace org

#endif //_IEEE_80211_CLIENT_FACTORY_H
/** @} */
