/**
 * @file APModeClient_Types.h
 * @author RBEI/ECO32 Jiji Anna Jacob
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */

#ifndef _AP_MODE_CLIENT_TYPES_H
#define _AP_MODE_CLIENT_TYPES_H

#include <string>
#include <vector>
#include <map>

#include "asf/core/Types.h"

#include "WBLTypes.h"

namespace org
{
namespace bosch
{

//Forward declarations
class AssociatedStationItem;
class AccessPointItem;
class IPv4Configuration;
class SPITechnologies;

typedef uint16 Channel;
typedef uint16 Frequency;

typedef std::vector< AssociatedStationItem > AssociatedStationList;
typedef std::vector< AccessPointItem > AccessPointList;
typedef std::map< Channel, Frequency > SupportedChannelList;
typedef std::vector< uint8 > ByteArray;
typedef ByteArray VendorIEList;
typedef std::map< WBLFrequencyBand, SPITechnologies> SupportedFrequencies;
typedef std::map< WBLTechnology, WBLRestrictState> TechnologyRestrictions;
typedef std::vector< IPv4Configuration > IPv4ConfigurationList;


class AssociatedStationProperty
{
public:
   AssociatedStationProperty();
   AssociatedStationProperty(const AssociatedStationProperty &ref);
   AssociatedStationProperty& operator=(const AssociatedStationProperty &ref);
   bool operator==(const AssociatedStationProperty &ref);
   virtual ~AssociatedStationProperty();
   ::std::string macAddress;
   ::std::string apPath;
   ::std::string interface;
   ::std::string ipAddress;
   ::std::string hostName;
   bool isEmpty();
};

class AssociatedStationItem final
{
public:
   AssociatedStationItem();
   AssociatedStationItem(const AssociatedStationItem &ref);
   AssociatedStationItem& operator =(const AssociatedStationItem &ref);
   bool operator==(const AssociatedStationItem &ref);
   virtual ~AssociatedStationItem();
   ::std::string objPath;
   bool updated;
   AssociatedStationProperty property;
};

class AccessPointProperty
{
public:
   AccessPointProperty();
   AccessPointProperty(const AccessPointProperty &ref);
   AccessPointProperty& operator=(const AccessPointProperty &ref);
   bool operator==(const AccessPointProperty &ref);
   virtual ~AccessPointProperty();
   ::std::string macAddress;
   ByteArray ssid;
   ::std::string interface;
   WBLPowerStateType powerState;
   WBLPowerFailureType powerFailure;
   bool isPowered;
   WBLSecurityType security;
   ::std::string passphrase;
   SupportedChannelList chanList;
   uint16 currChannel;
   uint16  maxStations;
   VendorIEList vendorIEs;
   bool isHidden;
   AssociatedStationList asList;
   std::string _regDom;
   WBLAPType type;
   IPv4ConfigurationList ipv4ConfigurationList;
   bool isTethering;
   bool isVendorElementRegistered;
   uint32 connHealth;
   WifiAccessNetworkType wifiAccessNetworkType;
};

class AccessPointItem final
{
public:
   AccessPointItem();
   AccessPointItem(const AccessPointItem &ref);
   AccessPointItem& operator=(const AccessPointItem &ref);
   bool operator==(const AccessPointItem &ref);
   virtual ~AccessPointItem();
   ::std::string objPath;
   AccessPointProperty property;
};

class IPv4Configuration final
{
public:
   IPv4Configuration();
   IPv4Configuration(const IPv4Configuration &ref);
   IPv4Configuration& operator=(const IPv4Configuration &ref);
   bool operator==(const IPv4Configuration &ref);
   virtual ~IPv4Configuration();
   bool isEmpty();
   ::std::string router;
   ::std::string startAddress;
   ::std::string endAddress;
   ::std::string netMask;
   ::std::string network;
   ::std::string broadcast;
   uint32 leasetime;
};

class SPITechnologies final
{
public:
    SPITechnologies();
    SPITechnologies(const SPITechnologies &ref);
    SPITechnologies& operator=(const SPITechnologies &ref);
    bool operator==(const SPITechnologies &ref);
    virtual ~SPITechnologies();
    bool isCPWSupport;
    bool isAAWSupport;
};

} //namespace bosch
} //namespace org

#endif //_AP_MODE_CLIENT_TYPES_H

/** @} */
