/**
 * @file APModeClient_Msgs.h
 * @author RBEI/ECO32 Jiji Anna Jacob
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */

#ifndef _AP_MODE_CLIENT_MSGS_H
#define _AP_MODE_CLIENT_MSGS_H

#include <string>

#include "IEEE80211EventMsg.h"
#include "APModeClient_Types.h"

namespace org
{
namespace bosch
{

class AccessPointAddedMsg : public IEEE80211EventMsg
{
public:
   AccessPointAddedMsg() :
         IEEE80211EventMsg(IEEE80211_MSG_AP_MODE_APADDED_IND)
   {
   }
   virtual ~AccessPointAddedMsg()
   {
   }
   void setAccessPointItem(const AccessPointItem& apItem)
   {
      _apItem = apItem;
   }
   void getAccessPointItem(AccessPointItem& apItem) const
   {
      apItem = _apItem;
   }
private:
   AccessPointItem _apItem;
};

class AccessPointRemovedMsg : public IEEE80211EventMsg
{
public:
   AccessPointRemovedMsg() :
         IEEE80211EventMsg(IEEE80211_MSG_AP_MODE_APREMOVED_IND)
   {
   }
   virtual ~AccessPointRemovedMsg()
   {
   }
   ::std::string getObjPath() const
   {
      return _objPath;
   }
   void setobjPath(const ::std::string objPath)
   {
      _objPath = objPath;
   }
private:
   ::std::string _objPath;
};

class AccessPointChangedMsg : public IEEE80211EventMsg
{
public:
   AccessPointChangedMsg() :
         IEEE80211EventMsg(IEEE80211_MSG_UNKNOWN)
   {
   }
   virtual ~AccessPointChangedMsg()
   {
   }
   void setAccessPointItem(const AccessPointItem& apItem)
   {
      _apItem = apItem;
   }
   void getAccessPointItem(AccessPointItem& apItem) const
   {
      apItem = _apItem;
   }
private:
   AccessPointItem _apItem;
};

class AssociatedStationAddedMsg : public IEEE80211EventMsg
{
public:
   AssociatedStationAddedMsg() :
         IEEE80211EventMsg(IEEE80211_MSG_AP_MODE_ASADDED_IND)
   {
   }
   virtual ~AssociatedStationAddedMsg()
   {
   }
   void setAssociatedStationItem(const AssociatedStationItem& stationItem)
   {
      _asItem = stationItem;
   }
   void getAssociatedStationItem(AssociatedStationItem& stationItem) const
   {
      stationItem = _asItem;
   }
private:
   AssociatedStationItem _asItem;
};

class AssociatedStationRemovedMsg : public IEEE80211EventMsg
{
public:
   AssociatedStationRemovedMsg() :
         IEEE80211EventMsg(IEEE80211_MSG_AP_MODE_ASREMOVED_IND)
   {
   }
   virtual ~AssociatedStationRemovedMsg()
   {
   }
   ::std::string getObjPath() const
   {
      return _objPath;
   }
   void setobjPath(::std::string objPath)
   {
      _objPath = objPath;
   }
private:
   ::std::string _objPath;
};

class AssociatedStationChangedMsg : public IEEE80211EventMsg
{
public:
   AssociatedStationChangedMsg() :
         IEEE80211EventMsg(IEEE80211_MSG_AP_MODE_ASCHANGED_IND)
   {
   }
   virtual ~AssociatedStationChangedMsg()
   {
   }
   void setAssociatedStationItem(const AssociatedStationItem& stationItem)
   {
      _asItem = stationItem;
   }
   void getAssociatedStationItem(AssociatedStationItem& stationItem) const
   {
      stationItem = _asItem;
   }
private:
   AssociatedStationItem _asItem;
};

class RestoreAccessPointMsg : public IEEE80211EventMsg
{
public:
   RestoreAccessPointMsg() :
         IEEE80211EventMsg(IEEE80211_MSG_UNKNOWN),
         _restoreType(WBL_AP_RESTORE_UNKOWN)
   {

   }
   virtual ~RestoreAccessPointMsg()
   {
   }
  /* void setAccessPointItem(const AccessPointItem& apItem)
   {
      _apItem = apItem;
   }
   void getAccessPointItem(AccessPointItem& apItem) const
   {
      apItem = _apItem;
   }*/
   void setRestoreType(WBLAPRestoreType type)
   {
      _restoreType = type;
   }
   void getRestoreType(WBLAPRestoreType &type) const
   {
      type = _restoreType;
   }

private:
   WBLAPRestoreType _restoreType;
};

} //namespace bosch
} //namespace org

#endif //_AP_MODE_CLIENT_MSGS_H

/** @} */
