/**
 * @file IDBManager.h
 * @author RBEI/ECO32 Jiji Anna Jacob
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 *
 * @{
 */

#ifndef _I_DB_MANAGER_IF_H
#define _I_DB_MANAGER_IF_H

#include "WBLMessageTypes.h"

namespace org
{
namespace bosch
{

class IDBManager
{
   public:

      virtual ~IDBManager()
      {

      }
      virtual ::std::string getRegulatoryInfo(const ::std::string &group) = 0;
      virtual int setRegulatoryInfo(const ::std::string &country, ::std::string &group) = 0;
      virtual int getRegulatoryWatchDogInfo(const ::std::string &group, const ::std::string &key,
    		  unsigned int *watchDogVal) = 0;
      virtual int setRegulatoryWatchDogInfo(::std::string &group, const ::std::string &key,
    		  unsigned int watchDogVal) = 0;
      virtual int removeKey(::std::string &group, const ::std::string &key) = 0;
      virtual int getRegulatorySources(::std::string &group, const ::std::string &key, ::std::string &sources) = 0;
      virtual int getHWLimitationInfo(const ::std::string &group, HWLimitationInfo &info) = 0;

      //TO DO : Extend i/f for create and delete DB
      virtual bool readLIMFromDB(LIMList& list) = 0;
      virtual bool writeLIMToDB(const LIMItem& item) = 0;
      virtual void removeLIMItem(const WifiMode& mode) = 0;
      virtual bool readPoweredSetting(const WifiMode mode,::std::string& objPath) = 0;

      virtual bool readPMFromDB(PriorityList& list, uint &timer) = 0;
      virtual bool writeModesToDB(const PriorityList& list) = 0;
      virtual bool writeTimerToDB(const uint &timer) = 0;

      virtual bool writeAPConfigsToDB(const APSetup &configAPSetup,const bool isRestricted) = 0;
      virtual bool readAPConfigsFromDB(APSetup &configAPSetup,bool &isRestricted) = 0;

      virtual ::std::string getAPTypePassphrase(const WBLAPType type) = 0;
      virtual bool setAPTypePassphrase(const WBLAPType type,const ::std::string &passphrase) = 0;
      virtual void  clearLIMData() = 0;
};

} //namespace bosch
} //namespace org

#endif //_I_DB_MANAGER_IF_H

/** @} */

