/**
 * @file Crypto_SDC.h
 * @author RBEI/ECO3 Murali Kakkanavar
 * @copyright (c) 2020 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 * @brief
 *
 * @{
 */

#ifndef CRYPTO_SDC_H_
#define CRYPTO_SDC_H_

#include "CryptoUtility.h"
#include <glib.h>
#include "asf/core/Logger.h"
#include "sdc_perm.h"         // needed for type "sdc_permissions_t"
#include "sdc_session.h"      // needed for "sdc_open_session(..)"
#include "sdc_keystore_keys.h"// needed for "sdc_generate_random_storage_key(..)"
                              // and enumerations like 'SDC_CREATE_KEY_FIXED_ID'
#include "DBDefines.h"


namespace org
{
namespace bosch
{

class CryptoSDC: public CryptoUtil
{
public:
    CryptoSDC();
     virtual ~CryptoSDC();
     /**
      * This function is used to write encrypted data into a required file
      *
      * \param[in] filepathEnc
      *      File path to write encrypted stream of data
      * \param[in] indata
      *      Input data for encryption
      * \param[in] length
      *      Input data length for encryption
      *
      * \return #BOOL
      * \retval #FALSE on success (file could be written)
      * \retval #TRUE on failure (file could not be written)
      *
      */
     bool cryptoUtilEncrypt (const char *filepathEnc,
             char* indata, size_t length);
     /**
      * This function is used to write a Bytestram (e.g. DER encoded ASN1 Message to a File
      *
      * \param[in] filepathEnc
      *      File path to read encrypted stream of data
      * \param[in] filepathPlain
      *      File path to write the stream of readable data
      *
      * \return #BOOL
      * \retval #FALSE on success (file could be written)
      * \retval #TRUE on failure (file could not be written)
      *
      */
     bool cryptoUtilDecrypt (const char *filepathEnc, const char *filepathPlain);
     /**
      * This function is used to register to SDC utility with required public key,
      * permissions and encryption/decryption algorithm
      *
      * \return #BOOL
      * \retval #FALSE on success (SDC utility registration possible)
      * \retval #TRUE on failure (SDC utility registration not possible)
      *
      */
     bool cryptoUtilRegister ();
     /**
      * This function is used to terminate the session for SDC utility
      *
      * \return #BOOL
      * \retval #FALSE on success (Termination not possible)
      * \retval #TRUE on failure (Termination possible)
      *
      */
     bool cryptoUtilUnregister ();

private:
     /**
     * This function checks the SDC return code
     *
     * \param[in] ret
     *    SDC return code
     *
     * \return #BOOL
     * \retval #FALSE on success, means SDC return code is SDC_OK
     * \retval #TRUE on failure, means SDC return code is not SDC_OK
     */
    bool checkSDCErrorCode ( sdc_error_t ret );
    // Note: sdc_key_id_t == uint32,see /usr/include/adit-components/sdc.h
    sdc_session_t *poSdcSession;
    sdc_key_id_t sdcKeyId;
    sdc_wrap_unwrap_type_t *sdcType;

    DECLARE_CLASS_LOGGER();

};
}
}

#endif /* CRYPTO_SDC_H_ */
