/**
 * @file DBManagerFactory.h
 * @author RBEI/ECO32 Jiji Anna Jacob
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _DB_MANAGER_FACTORY_H
#define _DB_MANAGER_FACTORY_H

#include "WBLDefines.h"
#include "GenericSingleton.h"
#include "DBManager.h"

namespace org
{
namespace bosch
{

class DBManagerFactory final: public GenericSingleton< DBManagerFactory >
{

public:
   DBManagerFactory(const DBManagerFactory& ref);
   DBManagerFactory& operator=(const DBManagerFactory& ref);
   virtual ~DBManagerFactory()
   {
      RELEASE_MEM(_poDBManagerIf);
   }
   IDBManager* getDBManagerIf()
   {
      return _poDBManagerIf;
   }

private:
   friend class GenericSingleton< DBManagerFactory > ;
   DBManagerFactory() :
         _poDBManagerIf(nullptr)
   {
      _poDBManagerIf = new DBManager;
   }

   IDBManager* _poDBManagerIf;

};

} // namespace bosch
} // namespace org

#endif //_DB_MANAGER_FACTORY_H

/** @} */
