/**
 * @file DBDefines.h
 * @author RBEI/ECO32 Jiji Anna Jacob
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _WBL_DB_DEFINES_H
#define _WBL_DB_DEFINES_H

namespace org
{
namespace bosch
{

#define WBL_DB_PATH                     "/var/opt/bosch/dynamic/connectivity/db"
#define WBL_DB_FILE_PREFIX              "WBL_"

#define WBL_LIM_FILE                    WBL_DB_FILE_PREFIX"LastIntendedMode.txt"
#define WBL_LIM_FILE_PATH               WBL_DB_PATH "/" WBL_LIM_FILE

#define WBL_REGULATORY_FILE             WBL_DB_FILE_PREFIX"RegulatoryInfo.txt"
#define WBL_REGULATORY_FILE_PATH        WBL_DB_PATH "/" WBL_REGULATORY_FILE

#define WBL_PM_FILE                     WBL_DB_FILE_PREFIX"PriorityManagement.txt"
#define WBL_PM_FILE_PATH                WBL_DB_PATH "/" WBL_PM_FILE

#define WBL_HWLIMITATION_FILE           WBL_DB_FILE_PREFIX"HWLimitationInfo.txt"
#define WBL_HWLIMITATION_FILE_PATH      WBL_DB_PATH "/" WBL_HWLIMITATION_FILE

#define SDC_WBL_KEY_ID                  8102  // Key-ID for WBL files
#define SKEY_LENGTH_BYTES               32    // 32 byte = 256 bit
#define WBL_TEMP_PTH                    "/tmp"
#define WBL_LIM_TEMP_PATH                WBL_TEMP_PTH"/" WBL_LIM_FILE
#define IF_NOT_FAILED if ( failed == false )
#define IF_FAILED if ( failed == true )
#define likely(x)       __builtin_expect(!!(x), 1)
#define unlikely(x)     __builtin_expect(!!(x), 0)
#define return_val_if_fail(expr, val) \
    do { if (likely (expr)) { } else { LOG_ERROR ("Expected condition \"%s\" failed", #expr); return (val); } } while (0)
#define return_if_fail(expr) \
    do { if (likely (expr)) { } else { LOG_ERROR ("Expected condition \"%s\" failed", #expr); return; } } while (0)
/*#define READ_DATA_FROM_KEYFILE(type, keyfile, group, member, error) \
    g_key_file_get_ ## type (keyfile, group, member, error);

#define WRITE_DATA_TO_KEYFILE(type, keyfile, group, member, data) \
    g_key_file_set_ ## type (keyfile, group, member, data);

#define REMOVE_DATA_FROM_KEYFILE(keyfile, group, member, error) \
    g_key_file_remove_key(keyfile, group, member, error);*/

} //namespace bosch
} //namespace org

#endif //_WBL_DB_DEFINES_H

/** @} */
