/**
 * @file StateMachineTypes.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */
#ifndef _I_STATE_MACHINE_TYPES_H
#define _I_STATE_MACHINE_TYPES_H

namespace org
{
namespace bosch
{
//! Data types
enum WifiSetupEventID
{
   /* STA Mode events */
   WIFI_SETUP_EVENT_STA_TECH_ADDED = 0,
   WIFI_SETUP_EVENT_STA_TECH_REMOVED,
   WIFI_SETUP_EVENT_STA_POWERED,
   WIFI_SETUP_EVENT_STA_CONNECTED, 
   /* AP Mode events */
   WIFI_SETUP_EVENT_AP_ADDED,
   WIFI_SETUP_EVENT_AP_REMOVED,
   WIFI_SETUP_EVENT_AP_POWERED,
   WIFI_SETUP_EVENT_AP_POWERFAILURE,
   WIFI_SETUP_EVENT_AP_SSID,
   WIFI_SETUP_EVENT_AP_PASSPHRASE,
   WIFI_SETUP_EVENT_AP_CURRENTCHANNEL,
   WIFI_SETUP_EVENT_AP_SECURITY,
   WIFI_SETUP_EVENT_AP_VENDORID,
   WIFI_SETUP_EVENT_AP_SUPPCHANNELS,
   WIFI_SETUP_EVENT_AP_HIDDEN,
   WIFI_SETUP_EVENT_AP_SETOPERATINGCHANNEL,
   WIFI_SETUP_EVENT_AP_DEAUTHSTATION,
   WIFI_SETUP_EVENT_AP_CLEAR_DATA,
   WIFI_SETUP_EVENT_AP_TETHERING,
   WIFI_SETUP_EVENT_AP_MAXSTA,
   WIFI_SETUP_EVENT_AP_REG_VENDOR,
   WIFI_SETUP_EVENT_AP_UNREG_VENDOR,
   WIFI_SETUP_EVENT_AP_NETWORK_TYPE,
   /* AS Mode events */
   WIFI_SETUP_EVENT_AS_ADDED,
   WIFI_SETUP_EVENT_AS_REMOVED,
   WIFI_SETUP_EVENT_UNKNOWN = 255
};

enum WifiSetupStateType
{
   ST_SETUP_DISABLED = 0,
   ST_SETUP_IDLE,
   ST_PREPARING_SETUP,
   ST_DEACTIVATING_SETUP,
   ST_DISABLING_SETUP,
   ST_ENABLING_SETUP,
   ST_RESETTING_SETUP,
   ST_SETUP_ERROR
};

enum PreparingSetupSubstate
{
   PREP_SETUP_ST_RESOLVING_LIMITATIONS = 0,
   PREP_SETUP_ST_INITIATE_CONFIGURATION,
   PREP_SETUP_ST_CONFIGURING_FREQUENCY,
   PREP_SETUP_ST_CONFIGURING_CHANNEL,
   PREP_SETUP_ST_CONFIGURING_SSID,
   PREP_SETUP_ST_CONFIGURING_PASSPHRASE,
   PREP_SETUP_ST_CONFIGURING_SECURITY,
   PREP_SETUP_ST_CONFIGURING_VISIBILITY,
   PREP_SETUP_ST_CONFIGURING_TETHERING,
   PREP_SETUP_ST_CONFIGURING_NETWORKTYPE,
   PREP_SETUP_ST_CONFIGURING_MAXSTA,
   PREP_SETUP_ST_POWERING_ON,
   PREP_SETUP_ST_IDLE
};


enum ResetSetupSubstate
{
   RESET_SETUP_ST_POWERING_OFF =0,
   RESET_SETUP_ST_CLEAR_DATA,
   RESET_SETUP_ST_IDLE
};

} // namespace bosch
} // namespace org

#endif //_I_STATE_MACHINE_TYPES_H

/** @} */
