/**
 * @file StateMachineProperties.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _STATE_MACHINE_PROPERTIES_H
#define _STATE_MACHINE_PROPERTIES_H

#include <string>

#include "DbusProperties.h"
#include "StateMachineTypes.h"

namespace org
{
namespace bosch
{


class WifiSetupEventProperty: public DbusProperties
{
   public:
      WifiSetupEventProperty();
      virtual ~WifiSetupEventProperty();

      WifiSetupEventID getEvent2Enum(const ::std::string& value) const;
      const ::std::string& getEvent2String(const WifiSetupEventID value) const;

   private:
      const ::std::string _eventSTATechAdded;
      const ::std::string _eventSTATechRemoved;
      const ::std::string _eventSTAPowered;
      const ::std::string _eventSTAConnected;
      const ::std::string _eventAPAdded;
      const ::std::string _eventAPRemoved;
      const ::std::string _eventAPPowered;
      const ::std::string _eventAPSSID;
      const ::std::string _eventAPPassphrase;
      const ::std::string _eventAPCurrentChannel;
      const ::std::string _eventAPSecurity;
      const ::std::string _eventAPVendorID;
      const ::std::string _eventAPSuppChannels;
      const ::std::string _eventAPHidden;
      const ::std::string _eventAPTethering;
      const ::std::string _eventAPNetworkType;
      const ::std::string _eventAPMaxSta;
      const ::std::string _eventAPRegVendor;
      const ::std::string _eventAPUnRegVendor;
      const ::std::string _eventAPSetOpChannel;
      const ::std::string _eventAPDeauthStation;
      const ::std::string _eventAPCleared;
      const ::std::string _eventASAdded;
      const ::std::string _eventASRemoved;
      const ::std::string _eventUnknown;
};

class WifiSetupStateProperty: public DbusProperties
{
   public:
      WifiSetupStateProperty();
      virtual ~WifiSetupStateProperty();

      WifiSetupStateType getState2Enum(const ::std::string& value) const;
      const ::std::string& getState2String(const WifiSetupStateType value) const;

   private:
      const ::std::string _stateDisabled;
      const ::std::string _stateIdle;
      const ::std::string _statePreparing;
      const ::std::string _stateDeactivating;
      const ::std::string _stateDisabling;
      const ::std::string _stateEnabling;
      const ::std::string _stateResetting;
      const ::std::string _stateError;

};

class PreparingSetupSubstateProperty: public DbusProperties
{
   public:
      PreparingSetupSubstateProperty();
      virtual ~PreparingSetupSubstateProperty();

      PreparingSetupSubstate getSubstate2Enum(const ::std::string& value) const;
      const ::std::string& getSubstate2String(const PreparingSetupSubstate value) const;

   private:
      const ::std::string _stateResolvingLimitations;
      const ::std::string _stateInitiateConfigurations;
      const ::std::string _stateConfiguringFrequency;
      const ::std::string _stateConfiguringChannel;
      const ::std::string _stateConfiguringSSID;
      const ::std::string _stateConfiguringPassphrase;
      const ::std::string _stateConfiguringSecurity;
      const ::std::string _stateConfiguringVisibility;
      const ::std::string _stateConfiguringTethering;
      const ::std::string _stateConfiguringNetworkType;
      const ::std::string _stateConfiguringMaxSta;
      const ::std::string _statePoweringON;
      const ::std::string _stateIdle;

};

static WifiSetupEventProperty wifiSetupEvent;
static WifiSetupStateProperty wifiSetupState;
static PreparingSetupSubstateProperty prepSetupSubstate;

#define SM_EVENT_TO_STR(WIFI_SETUP_EVENT_ID) \
   (wifiSetupEvent.getEnum2StringTrace(WIFI_SETUP_EVENT_ID).c_str())
#define SM_STATE_TO_STR(WIFI_SETUP_STATE_TYPE) \
   (wifiSetupState.getEnum2StringTrace(WIFI_SETUP_STATE_TYPE).c_str())
#define PREP_SUBSTATE_TO_STR(PREPARING_SETUP_SUBSTATE) \
   (prepSetupSubstate.getEnum2StringTrace(PREPARING_SETUP_SUBSTATE).c_str())

} //namespace bosch
} //namespace org

#endif //_STATE_MACHINE_PROPERTIES_H

/** @} */
