/**
 * @file StateMachineManager.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */
#ifndef _STATE_MACHINE_MANAGER_H
#define _STATE_MACHINE_MANAGER_H

#include <boost/shared_ptr.hpp>
#include <map>

#include "asf/core/Logger.h"

#include "ICmdStateMachineManager.h"
#include "IRespWifiSetupControllerSM.h"
#include "ICmdWifiSetupControllerSM.h"
#include "WBLMessageTypes.h"
#include "WBLBaseMsg.h"
#include "StateMachineTypes.h"

namespace org
{
namespace bosch
{

//Forward declarations
class IRespStateMachineManager;

typedef ::boost::shared_ptr < ICmdWifiSetupControllerSM >  tCmdWifiSetupControllerSMSptr;

class StateMachineManager final: public ICmdStateMachineManager, public IRespWifiSetupControllerSM
{
public:

   explicit StateMachineManager();

   virtual ~StateMachineManager();

   void createStateMachines();
   void destroyStateMachines();

   //! Override ICmdStateMachineManager interfaces
   virtual void registerResponseIf(IRespStateMachineManager* responseIf) override;
   virtual void processRequest(::boost::shared_ptr< WBLBaseMsg > msg) override;
   virtual void processEvent(WifiSetupEventID eventID, const WifiSetUpItem& setup, bool isError = false) override;
   virtual void notifyActiveWiFiSetups(WifiSetUpList wifiSetups) override;
   virtual bool isSMBusy(WifiMode wifiMode) const override;

   //! Override IRespWifiSetupControllerSM interfaces
   virtual void sendMsgResponse(::boost::shared_ptr< WBLBaseMsg > msg, WBLErrorCode errorCode) override;
   virtual void sendRequest(::boost::shared_ptr< WBLBaseMsg > msg) override;
   virtual const WifiSetUpList& getAllWifiSetups() const override;

private:

   bool isSMAvailable(WifiMode wifiMode) const;

   IRespStateMachineManager* _respSMManagerIf;

   std::map < WifiMode, tCmdWifiSetupControllerSMSptr >  _stateMachinesMap;
   WifiSetUpList _activeWifiSetups;

   DECLARE_CLASS_LOGGER();
};

} // namespace bosch
} // namespace org

#endif //_STATE_MACHINE_MANAGER_H

/** @} */
