/**
 * @file ICmdStateMachineManager.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */
#ifndef _I_CMD_STATE_MACHINE_MANAGER_H
#define _I_CMD_STATE_MACHINE_MANAGER_H

#include <boost/shared_ptr.hpp>

#include "WBLBaseMsg.h"
#include "WBLMessageTypes.h"
#include "StateMachineTypes.h"
#include "IRespStateMachineManager.h"

namespace org
{
namespace bosch
{

class ICmdStateMachineManager
{
public:

   ICmdStateMachineManager()
   {
   }

   virtual ~ICmdStateMachineManager()
   {
   }

   virtual void registerResponseIf(IRespStateMachineManager* responseIf) = 0;
   virtual void processRequest(::boost::shared_ptr< WBLBaseMsg > msg) = 0;
   virtual void processEvent(WifiSetupEventID eventID, const WifiSetUpItem& setup, bool isError = false) = 0;
   virtual void notifyActiveWiFiSetups(WifiSetUpList wifiSetups) = 0;
   virtual bool isSMBusy(WifiMode wifiMode) const = 0;

private:

   ICmdStateMachineManager(const ICmdStateMachineManager&);
   ICmdStateMachineManager& operator=(const ICmdStateMachineManager&);

};

} // namespace bosch
} // namespace org

#endif //_I_CMD_STATE_MACHINE_MANAGER_H

/** @} */
