/**
 * @file SetupErrorState.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _SETUP_ERROR_STATE_H
#define _SETUP_ERROR_STATE_H

#include <boost/shared_ptr.hpp>

#include "asf/core/Logger.h"

#include "WBLMessageTypes.h"
#include "WifiSetupState.h"

namespace org
{
namespace bosch
{

// forward declarations

class SetupErrorState final: public WifiSetupState
{
public:

   explicit SetupErrorState(IWifiSetupSM* wifiSetupSMIf);
   virtual ~SetupErrorState();

   //! Override WifiSetupState interfaces
   virtual void onEntry(::boost::shared_ptr< StateMachineMsg > msg) override;

private:
   WBLErrorCode convertToWBLErrorCode(SMErrorCode smErrorCode) const;

   DECLARE_CLASS_LOGGER();
};

} // namespace bosch
} // namespace org

#endif //_SETUP_ERROR_STATE_H

/** @} */
